/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.api.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.api.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.block.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import it.zerono.mods.zerocore.util.CodeHelper;
import it.zerono.mods.zerocore.util.ItemHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMultiblockPart<PartType extends Enum<PartType>>
extends ModBlock {
    protected final PartType _partType;

    public BlockMultiblockPart(@Nonnull PartType type, @Nonnull String blockName, @Nonnull Material material) {
        super(blockName, material);
        this._partType = type;
    }

    @Nonnull
    public PartType getPartType() {
        return this._partType;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((IMultiblockPartType)this.getPartType()).createTileEntity(world, state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        TileEntity te = WorldHelper.getTile(world, position);
        if (te instanceof MultiblockTileEntityBase) {
            state = this.buildActualState(state, world, position, (MultiblockTileEntityBase)te);
        }
        return state;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos position, EnumFacing side) {
        IBlockState sideState = blockAccess.func_180495_p(position.func_177972_a(side));
        return this != sideState.func_177230_c();
    }

    public boolean func_180639_a(World world, BlockPos position, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hasTileEntity(state) && !player.func_70093_af()) {
            ItemStack heldItem = player.func_184586_b(hand);
            TileEntity te = WorldHelper.getTile((IBlockAccess)world, position);
            if (te instanceof IMultiblockPart && WorldHelper.calledByLogicalServer(world) && ItemHelper.stackIsEmpty(heldItem) && hand == EnumHand.OFF_HAND) {
                MultiblockControllerBase controller = ((IMultiblockPart)te).getMultiblockController();
                TextComponentTranslation message = null;
                if (null != controller) {
                    ValidationError error = controller.getLastError();
                    if (null != error) {
                        message = error.getChatMessage();
                    }
                } else {
                    message = new TextComponentTranslation("multiblock.validation.block_not_connected", new Object[0]);
                }
                if (null != message) {
                    CodeHelper.sendStatusMessage(player, (ITextComponent)message);
                    return true;
                }
            }
        }
        return super.func_180639_a(world, position, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Nonnull
    protected IBlockState buildActualState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos position, @Nonnull MultiblockTileEntityBase part) {
        return state;
    }
}

