/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.TorchmasterConfig;
import net.xalcon.torchmaster.common.logic.ITorchRegistry;
import net.xalcon.torchmaster.common.logic.ITorchRegistryContainer;
import net.xalcon.torchmaster.common.logic.TorchDistanceLogics;
import net.xalcon.torchmaster.common.logic.TorchRegistry;

public class TorchRegistryContainer
implements ITorchRegistryContainer {
    private ITorchRegistry megaTorchRegistry = new TorchRegistry(TorchDistanceLogics.Cubic){

        @Override
        protected boolean shouldHandleEntity(ResourceLocation entityName) {
            return TorchMasterMod.MegaTorchFilterRegistry.containsEntity(entityName);
        }

        @Override
        protected int getTorchRange() {
            return TorchmasterConfig.MegaTorchRange;
        }

        @Override
        protected boolean isBlockStateValid(IBlockState state) {
            return state.func_177230_c() == ModBlocks.getMegaTorch();
        }
    };
    private ITorchRegistry dreadLampRegistry = new TorchRegistry(TorchDistanceLogics.Cubic){

        @Override
        protected boolean shouldHandleEntity(ResourceLocation entityName) {
            return TorchMasterMod.DreadLampFilterRegistry.containsEntity(entityName);
        }

        @Override
        protected int getTorchRange() {
            return TorchmasterConfig.DreadLampRange;
        }

        @Override
        protected boolean isBlockStateValid(IBlockState state) {
            return state.func_177230_c() == ModBlocks.getDreadLamp();
        }
    };

    @Override
    public ITorchRegistry getMegaTorchRegistry() {
        return this.megaTorchRegistry;
    }

    @Override
    public ITorchRegistry getDreadLampRegistry() {
        return this.dreadLampRegistry;
    }

    @Override
    public boolean shouldEntityBeBlocked(Entity entity) {
        return this.megaTorchRegistry.shouldEntityBeBlocked(entity) || this.dreadLampRegistry.shouldEntityBeBlocked(entity);
    }

    @Override
    public void onGlobalTick(World world) {
        this.megaTorchRegistry.onGlobalTick(world);
        this.dreadLampRegistry.onGlobalTick(world);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("mega_torch", this.megaTorchRegistry.serializeNBT());
        nbt.func_74782_a("dread_lamp", this.dreadLampRegistry.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("mega_torch")) {
            this.megaTorchRegistry.deserializeNBT((NBTBase)nbt.func_150295_c("mega_torch", 10));
        }
        if (nbt.func_74764_b("dread_lamp")) {
            this.dreadLampRegistry.deserializeNBT((NBTBase)nbt.func_150295_c("dread_lamp", 10));
        }
    }
}

