/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.client;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.TorchmasterConfig;
import net.xalcon.torchmaster.common.logic.ITorchDistanceLogic;

public class ClientTorchRegistry {
    private ArrayList<BlockPos> torches = new ArrayList();
    private ITorchDistanceLogic distanceLogic;
    private int checkIndex = 0;

    public ClientTorchRegistry(ITorchDistanceLogic distanceLogic) {
        this.distanceLogic = distanceLogic;
    }

    public void addTorch(BlockPos pos) {
        if (!this.torches.contains(pos)) {
            TorchMasterMod.Log.info("Cached torch at position {}", (Object)pos);
            this.torches.add(pos);
        }
    }

    public void removeTorch(BlockPos pos) {
        TorchMasterMod.Log.info("Removed torch at position {}", (Object)pos);
        this.torches.remove(pos);
    }

    public void onClientTick(World world) {
        IBlockState state;
        if (this.torches.size() == 0) {
            return;
        }
        BlockPos pos = this.torches.get(this.checkIndex);
        if (world.func_175667_e(pos) && (state = world.func_180495_p(pos)).func_177230_c() != ModBlocks.getMegaTorch()) {
            this.removeTorch(pos);
        }
        this.checkIndex = (this.checkIndex + 1) % this.torches.size();
    }

    public boolean isPositionInRange(double posX, double posY, double posZ) {
        int torchRange = TorchmasterConfig.MegaTorchRange;
        for (BlockPos torch : this.torches) {
            if (!this.distanceLogic.isPositionInRange(posX, posY, posZ, torch, torchRange)) continue;
            return true;
        }
        return false;
    }
}

