/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.aspects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.apache.commons.lang3.text.WordUtils;
import thaumcraft.api.research.ScanAspect;
import thaumcraft.api.research.ScanningManager;

public class Aspect {
    String tag;
    Aspect[] components;
    int color;
    private String chatcolor;
    ResourceLocation image;
    int blend;
    public static HashMap<Integer, Aspect> mixList = new HashMap();
    private static ArrayList<Aspect> primals = new ArrayList();
    private static ArrayList<Aspect> compounds = new ArrayList();
    public static LinkedHashMap<String, Aspect> aspects = new LinkedHashMap();
    public static final Aspect AIR = new Aspect("aer", 0xFFFF7E, "e", 1);
    public static final Aspect EARTH = new Aspect("terra", 5685248, "2", 1);
    public static final Aspect FIRE = new Aspect("ignis", 16734721, "c", 1);
    public static final Aspect WATER = new Aspect("aqua", 3986684, "3", 1);
    public static final Aspect ORDER = new Aspect("ordo", 14013676, "7", 1);
    public static final Aspect ENTROPY = new Aspect("perditio", 0x404040, "8", 771);
    public static final Aspect VOID = new Aspect("vacuos", 0x888888, new Aspect[]{AIR, ENTROPY}, 771);
    public static final Aspect LIGHT = new Aspect("lux", 0xFFFFC0, new Aspect[]{AIR, FIRE});
    public static final Aspect MOTION = new Aspect("motus", 13487348, new Aspect[]{AIR, ORDER});
    public static final Aspect COLD = new Aspect("gelum", 0xE1FFFF, new Aspect[]{FIRE, ENTROPY});
    public static final Aspect CRYSTAL = new Aspect("vitreus", 0x80FFFF, new Aspect[]{EARTH, AIR});
    public static final Aspect METAL = new Aspect("metallum", 11908557, new Aspect[]{EARTH, ORDER});
    public static final Aspect LIFE = new Aspect("victus", 14548997, new Aspect[]{EARTH, WATER});
    public static final Aspect DEATH = new Aspect("mortuus", 6946821, new Aspect[]{WATER, ENTROPY});
    public static final Aspect ENERGY = new Aspect("potentia", 0xC0FFFF, new Aspect[]{ORDER, FIRE});
    public static final Aspect EXCHANGE = new Aspect("permutatio", 5735255, new Aspect[]{ENTROPY, ORDER});
    public static final Aspect MAGIC = new Aspect("praecantatio", 0xCF00FF, new Aspect[]{ENERGY, AIR});
    public static final Aspect AURA = new Aspect("auram", 0xFFC0FF, new Aspect[]{MAGIC, AIR});
    public static final Aspect ALCHEMY = new Aspect("alkimia", 2337949, new Aspect[]{MAGIC, WATER});
    public static final Aspect FLUX = new Aspect("vitium", 0x800080, new Aspect[]{ENTROPY, MAGIC});
    public static final Aspect DARKNESS = new Aspect("tenebrae", 0x222222, new Aspect[]{VOID, LIGHT});
    public static final Aspect ELDRITCH = new Aspect("alienis", 0x805080, new Aspect[]{VOID, DARKNESS});
    public static final Aspect FLIGHT = new Aspect("volatus", 0xE7E7D7, new Aspect[]{AIR, MOTION});
    public static final Aspect PLANT = new Aspect("herba", 109568, new Aspect[]{LIFE, EARTH});
    public static final Aspect TOOL = new Aspect("instrumentum", 0x4040EE, new Aspect[]{METAL, ENERGY});
    public static final Aspect CRAFT = new Aspect("fabrico", 8428928, new Aspect[]{EXCHANGE, TOOL});
    public static final Aspect MECHANISM = new Aspect("machina", 0x8080A0, new Aspect[]{MOTION, TOOL});
    public static final Aspect TRAP = new Aspect("vinculum", 10125440, new Aspect[]{MOTION, ENTROPY});
    public static final Aspect SOUL = new Aspect("spiritus", 0xEBEBFB, new Aspect[]{LIFE, DEATH});
    public static final Aspect MIND = new Aspect("cognitio", 16356991, new Aspect[]{FIRE, SOUL});
    public static final Aspect SENSES = new Aspect("sensus", 0xC0FFC0, new Aspect[]{AIR, SOUL});
    public static final Aspect AVERSION = new Aspect("aversio", 0xC05050, new Aspect[]{SOUL, ENTROPY});
    public static final Aspect PROTECT = new Aspect("praemunio", 49344, new Aspect[]{SOUL, EARTH});
    public static final Aspect DESIRE = new Aspect("desiderium", 15121988, new Aspect[]{SOUL, VOID});
    public static final Aspect UNDEAD = new Aspect("exanimis", 3817472, new Aspect[]{MOTION, DEATH});
    public static final Aspect BEAST = new Aspect("bestia", 10445833, new Aspect[]{MOTION, LIFE});
    public static final Aspect MAN = new Aspect("humanus", 16766912, new Aspect[]{SOUL, LIFE});

    public Aspect(String tag, int color, Aspect[] components, ResourceLocation image, int blend) {
        if (aspects.containsKey(tag)) {
            throw new IllegalArgumentException(tag + " already registered!");
        }
        this.tag = tag;
        this.components = components;
        this.color = color;
        this.image = image;
        this.blend = blend;
        aspects.put(tag, this);
        ScanningManager.addScannableThing(new ScanAspect("!" + tag, this));
        if (components != null) {
            int h = (components[0].getTag() + components[1].getTag()).hashCode();
            mixList.put(h, this);
        }
    }

    public Aspect(String tag, int color, Aspect[] components) {
        this(tag, color, components, new ResourceLocation("thaumcraft", "textures/aspects/" + tag.toLowerCase() + ".png"), 1);
    }

    public Aspect(String tag, int color, Aspect[] components, int blend) {
        this(tag, color, components, new ResourceLocation("thaumcraft", "textures/aspects/" + tag.toLowerCase() + ".png"), blend);
    }

    public Aspect(String tag, int color, String chatcolor, int blend) {
        this(tag, color, (Aspect[])null, blend);
        this.setChatcolor(chatcolor);
    }

    public int getColor() {
        return this.color;
    }

    public String getName() {
        return WordUtils.capitalizeFully((String)this.tag);
    }

    public String getLocalizedDescription() {
        return I18n.func_74838_a((String)("tc.aspect." + this.tag));
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Aspect[] getComponents() {
        return this.components;
    }

    public void setComponents(Aspect[] components) {
        this.components = components;
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public static Aspect getAspect(String tag) {
        return aspects.get(tag);
    }

    public int getBlend() {
        return this.blend;
    }

    public void setBlend(int blend) {
        this.blend = blend;
    }

    public boolean isPrimal() {
        return this.getComponents() == null || this.getComponents().length != 2;
    }

    public static ArrayList<Aspect> getPrimalAspects() {
        if (primals.isEmpty()) {
            Collection<Aspect> pa = aspects.values();
            for (Aspect aspect : pa) {
                if (!aspect.isPrimal()) continue;
                primals.add(aspect);
            }
        }
        return primals;
    }

    public static ArrayList<Aspect> getCompoundAspects() {
        if (compounds.isEmpty()) {
            Collection<Aspect> pa = aspects.values();
            for (Aspect aspect : pa) {
                if (aspect.isPrimal()) continue;
                compounds.add(aspect);
            }
        }
        return compounds;
    }

    public String getChatcolor() {
        return this.chatcolor;
    }

    public void setChatcolor(String chatcolor) {
        this.chatcolor = chatcolor;
    }
}

