/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.EssentiaStack;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.integration.appeng.AEEssentiaStack;
import thaumicenergistics.util.ThELog;

public class AEUtil {
    private static KeyBinding focusKeyBinding;

    public static String getDisplayName(Object o) {
        if (o instanceof ItemStack) {
            return ((ItemStack)o).func_82833_r();
        }
        if (o instanceof IAEItemStack) {
            return ((IAEItemStack)o).getDefinition().func_82833_r();
        }
        if (o instanceof IAEFluidStack) {
            return ((IAEFluidStack)o).getFluidStack().getLocalizedName();
        }
        if (o instanceof IAEEssentiaStack) {
            return ((IAEEssentiaStack)o).getAspect().getName();
        }
        return "NAMENOTFOUND";
    }

    public static String getModID(Object o) {
        ResourceLocation rl = null;
        if (o instanceof ItemStack) {
            return AEUtil.getModID(((ItemStack)o).func_77973_b());
        }
        if (o instanceof EntityItem) {
            return AEUtil.getModID(((EntityItem)o).func_92059_d());
        }
        if (o instanceof Item) {
            rl = ((Item)o).getRegistryName();
        } else if (o instanceof Block) {
            rl = ((Block)o).getRegistryName();
        } else if (o instanceof IAEItemStack) {
            rl = ((IAEItemStack)o).getDefinition().func_77973_b().getRegistryName();
        } else {
            if (o instanceof IAEFluidStack) {
                return FluidRegistry.getModId((FluidStack)((IAEFluidStack)o).getFluidStack());
            }
            if (o instanceof IAEEssentiaStack) {
                return "Thaumcraft";
            }
        }
        return rl != null ? rl.func_110624_b() : "MODIDNOTFOUND";
    }

    public static long getStackSize(Object o) {
        if (o instanceof ItemStack) {
            return ((ItemStack)o).func_190916_E();
        }
        if (o instanceof IAEStack) {
            return ((IAEStack)o).getStackSize();
        }
        return 0L;
    }

    public static <T extends IAEStack<T>> T inventoryInsert(T input, IMEInventory<T> inv, IActionSource src) {
        return AEUtil.inventoryInsert(input, inv, src, null, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T inventoryInsert(T input, IMEInventory<T> inv, IActionSource src, Actionable mode) {
        return AEUtil.inventoryInsert(input, inv, src, null, mode);
    }

    public static <T extends IAEStack<T>> T inventoryInsert(T input, IMEInventory<T> inv, IActionSource src, IEnergySource energy) {
        return AEUtil.inventoryInsert(input, inv, src, energy, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T inventoryInsert(T input, IMEInventory<T> inv, IActionSource src, IEnergySource energy, Actionable mode) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(inv);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)mode);
        IAEStack notAdded = inv.injectItems(input.copy(), Actionable.SIMULATE, src);
        long toAdd = input.getStackSize();
        if (notAdded != null) {
            toAdd -= notAdded.getStackSize();
        }
        double energyFactor = 0.0;
        if (energy != null) {
            energyFactor = Math.max(1.0, (double)inv.getChannel().transferFactor());
            double availablePower = energy.extractAEPower((double)toAdd / energyFactor, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            toAdd = Math.min((long)(availablePower * energyFactor + 0.9), toAdd);
        }
        if (toAdd < 1L) {
            return input;
        }
        if (mode == Actionable.SIMULATE) {
            IAEStack s = input.copy().setStackSize(input.getStackSize() - toAdd);
            return (T)(s != null && s.getStackSize() > 0L ? s : null);
        }
        if (energy != null) {
            energy.extractAEPower((double)toAdd / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        if (input.getStackSize() == toAdd) {
            return (T)inv.injectItems(input, Actionable.MODULATE, src);
        }
        IAEStack split = input.copy();
        input.setStackSize(toAdd);
        split.decStackSize(toAdd);
        split.add(inv.injectItems(input, Actionable.MODULATE, src));
        return (T)(split.getStackSize() > 0L ? split : null);
    }

    public static <T extends IAEStack<T>> T inventoryExtract(T input, IMEInventory<T> inv, IActionSource src) {
        return AEUtil.inventoryExtract(input, inv, src, null, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T inventoryExtract(T input, IMEInventory<T> inv, IActionSource src, Actionable mode) {
        return AEUtil.inventoryExtract(input, inv, src, null, mode);
    }

    public static <T extends IAEStack<T>> T inventoryExtract(T input, IMEInventory<T> inv, IActionSource src, IEnergySource energy) {
        return AEUtil.inventoryExtract(input, inv, src, energy, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T inventoryExtract(T input, IMEInventory<T> inv, IActionSource src, IEnergySource energy, Actionable mode) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(inv);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)mode);
        IAEStack canExtract = inv.extractItems(input.copy(), Actionable.SIMULATE, src);
        if (canExtract == null) {
            return null;
        }
        long toExtract = canExtract.getStackSize();
        double energyFactor = 0.0;
        if (energy != null) {
            energyFactor = Math.max(1.0, (double)inv.getChannel().transferFactor());
            double availablePower = energy.extractAEPower((double)toExtract / energyFactor, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            toExtract = Math.min((long)(availablePower * energyFactor + 0.9), toExtract);
        }
        if (toExtract < 1L) {
            return null;
        }
        if (mode == Actionable.SIMULATE) {
            return (T)canExtract.setStackSize(toExtract);
        }
        if (energy != null) {
            energy.extractAEPower((double)toExtract / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        canExtract.setStackSize(toExtract);
        return (T)inv.extractItems(canExtract, Actionable.MODULATE, src);
    }

    public static boolean doesStorageContain(IMEInventory inv, IAEStack stack) {
        return inv.getAvailableItems(inv.getChannel().createList()).findPrecise(stack) != null;
    }

    public static boolean doesStorageContain(IMEInventory inv, Aspect aspect) {
        return AEUtil.doesStorageContain(inv, AEEssentiaStack.fromEssentiaStack(new EssentiaStack(aspect, 1)));
    }

    public static IAEEssentiaStack getAEStackFromAspect(Aspect aspect, int amount) {
        return (IAEEssentiaStack)((IEssentiaStorageChannel)AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class)).createStack(new EssentiaStack(aspect, amount));
    }

    public static IAEEssentiaStack getAEStackFromAspect(Aspect aspect) {
        return AEUtil.getAEStackFromAspect(aspect, Integer.MAX_VALUE);
    }

    public static <T extends IAEStack<T>, C extends IStorageChannel<T>> C getStorageChannel(Class<C> clazz) {
        return (C)AEApi.instance().storage().getStorageChannel(clazz);
    }

    public static <T extends IAEStack<T>> IItemList<T> getList(IStorageChannel<T> channel) {
        return channel.createList();
    }

    public static <T extends IAEStack<T>, C extends IStorageChannel<T>> IItemList<T> getList(Class<C> clazz) {
        return AEUtil.getList(AEUtil.getStorageChannel(clazz));
    }

    public static KeyBinding getFocusKeyBinding() {
        if (focusKeyBinding == null) {
            for (KeyBinding key : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
                if (!key.func_151466_e().equalsIgnoreCase("key.appliedenergistics2.category") || !key.func_151464_g().equalsIgnoreCase("key.toggle_focus.desc")) continue;
                focusKeyBinding = key;
                break;
            }
        }
        return focusKeyBinding;
    }

    public static boolean clearIntoMEInventory(IItemHandler handler, IMEInventory<IAEItemStack> inv, IActionSource src) {
        Preconditions.checkNotNull((Object)handler);
        Preconditions.checkNotNull(inv);
        Preconditions.checkNotNull((Object)src);
        if (handler.getSlots() < 1) {
            return true;
        }
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot).func_77946_l();
            if (stack.func_190926_b()) continue;
            IAEItemStack aeStack = (IAEItemStack)AEUtil.getStorageChannel(IItemStorageChannel.class).createStack((Object)stack);
            if (aeStack == null || aeStack.getStackSize() != (long)stack.func_190916_E()) {
                ThELog.warn("Failed to create IAEItemStack for {}, report to developer!", stack.toString());
                return false;
            }
            IAEItemStack returned = AEUtil.inventoryInsert(aeStack, inv, src);
            if (returned != null && returned.getStackSize() > 0L) {
                handler.extractItem(slot, Math.toIntExact((long)stack.func_190916_E() - returned.getStackSize()), false);
                return false;
            }
            handler.extractItem(slot, stack.func_190916_E(), false);
        }
        return true;
    }

    public static boolean isWrench(ItemStack stack, EntityPlayer player, BlockPos pos) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IAEWrench) {
            return ((IAEWrench)stack.func_77973_b()).canWrench(stack, player, pos);
        }
        return false;
    }
}

