/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tile;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.GridAccessException;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.tile.TileNetwork;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;

public class TileInfusionProvider
extends TileNetwork
implements IAspectSource {
    private AspectList clientAspects = new AspectList();

    public IItemList<IAEEssentiaStack> getStoredAspects() {
        IItemList list;
        IEssentiaStorageChannel channel = this.getChannel();
        try {
            IStorageGrid storage = GridUtil.getStorageGrid(this);
            list = storage.getInventory((IStorageChannel)channel).getStorageList();
        }
        catch (GridAccessException e) {
            list = channel.createList();
        }
        return list;
    }

    public AspectList getAspects() {
        if (ForgeUtil.isClient()) {
            return this.clientAspects;
        }
        AspectList list = new AspectList();
        IItemList<IAEEssentiaStack> stored = this.getStoredAspects();
        for (IAEEssentiaStack stack : stored) {
            list.add(stack.getAspect(), stack.getStackSize() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)stack.getStackSize());
        }
        return list;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        try {
            IStorageGrid storage = GridUtil.getStorageGrid(this);
            IMEMonitor monitor = storage.getInventory((IStorageChannel)this.getChannel());
            IAEEssentiaStack canExtract = (IAEEssentiaStack)monitor.extractItems((IAEStack)AEUtil.getAEStackFromAspect(aspect, i), Actionable.SIMULATE, (IActionSource)this.src);
            if (canExtract == null || canExtract.getStackSize() != (long)i) {
                return false;
            }
            monitor.extractItems((IAEStack)canExtract, Actionable.MODULATE, (IActionSource)this.src);
            this.func_70296_d();
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (ForgeUtil.isClient()) {
            return super.func_189515_b(tag);
        }
        super.func_189515_b(tag);
        this.getAspects().writeToNBT(tag, "storedAspects");
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("storedAspects")) {
            this.clientAspects = new AspectList();
            this.clientAspects.readFromNBT(tag, "storedAspects");
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public boolean isBlocked() {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return this.containerContains(aspect) >= i;
    }

    public int containerContains(Aspect aspect) {
        return this.getAspects().getAmount(aspect);
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return false;
    }

    public void setAspects(AspectList aspectList) {
    }

    public int addToContainer(Aspect aspect, int i) {
        return i;
    }

    @Deprecated
    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    @Deprecated
    public boolean doesContainerContain(AspectList aspectList) {
        return false;
    }
}

