/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.init;

import appeng.api.definitions.IItemDefinition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumicenergistics.api.IThEItems;
import thaumicenergistics.client.render.IThEModel;
import thaumicenergistics.definitions.ThEItemDefinition;
import thaumicenergistics.item.ItemBase;
import thaumicenergistics.item.ItemCreativeEssentiaCell;
import thaumicenergistics.item.ItemDummyAspect;
import thaumicenergistics.item.ItemEssentiaCell;
import thaumicenergistics.item.ItemMaterial;
import thaumicenergistics.item.part.ItemArcaneTerminal;
import thaumicenergistics.item.part.ItemEssentiaExportBus;
import thaumicenergistics.item.part.ItemEssentiaImportBus;
import thaumicenergistics.item.part.ItemEssentiaStorageBus;
import thaumicenergistics.item.part.ItemEssentiaTerminal;
import thaumicenergistics.util.ThELog;

@Mod.EventBusSubscriber
public class ThEItems
implements IThEItems {
    public static List<ItemBase> ITEMS = new ArrayList<ItemBase>();
    private final IItemDefinition itemEssentiaCell1k = ThEItems.createItem(new ItemEssentiaCell("1k", 1024, 12));
    private final IItemDefinition itemEssentiaCell4k = ThEItems.createItem(new ItemEssentiaCell("4k", 4096, 12));
    private final IItemDefinition itemEssentiaCell16k = ThEItems.createItem(new ItemEssentiaCell("16k", 16384, 12));
    private final IItemDefinition itemEssentiaCell64k = ThEItems.createItem(new ItemEssentiaCell("64k", 65536, 12));
    private final IItemDefinition itemEssentiaCellCreative = ThEItems.createItem(new ItemCreativeEssentiaCell());
    private final IItemDefinition itemEssentiaImportBus = ThEItems.createItem(new ItemEssentiaImportBus("essentia_import"));
    private final IItemDefinition itemEssentiaExportBus = ThEItems.createItem(new ItemEssentiaExportBus("essentia_export"));
    private final IItemDefinition itemEssentiaStorageBus = ThEItems.createItem(new ItemEssentiaStorageBus("essentia_storage"));
    private final IItemDefinition itemEssentiaTerminal = ThEItems.createItem(new ItemEssentiaTerminal("essentia_terminal"));
    private final IItemDefinition itemArcaneTerminal = ThEItems.createItem(new ItemArcaneTerminal("arcane_terminal"));
    private final IItemDefinition itemDiffusionCore = ThEItems.createItem(new ItemMaterial("diffusion_core"));
    private final IItemDefinition itemCoalescenceCore = ThEItems.createItem(new ItemMaterial("coalescence_core"));
    private final IItemDefinition itemEssentiaComponent1k = ThEItems.createItem(new ItemMaterial("essentia_component_1k"));
    private final IItemDefinition itemEssentiaComponent4k = ThEItems.createItem(new ItemMaterial("essentia_component_4k"));
    private final IItemDefinition itemEssentiaComponent16k = ThEItems.createItem(new ItemMaterial("essentia_component_16k"));
    private final IItemDefinition itemEssentiaComponent64k = ThEItems.createItem(new ItemMaterial("essentia_component_64k"));
    private final IItemDefinition itemUpgradeArcane = ThEItems.createItem(new ItemMaterial("upgrade_arcane"));
    private final IItemDefinition itemDummyAspect = ThEItems.createItem(new ItemDummyAspect());

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ThELog.info("Registering {} Items", ITEMS.size());
        event.getRegistry().registerAll((IForgeRegistryEntry[])ITEMS.toArray(new ItemBase[0]));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        ITEMS.forEach(item -> {
            if (item instanceof IThEModel) {
                ((IThEModel)((Object)item)).initModel();
            }
        });
    }

    private static IItemDefinition createItem(ItemBase item) {
        ITEMS.add(item);
        return new ThEItemDefinition(item);
    }

    @Override
    public IItemDefinition essentiaCell1k() {
        return this.itemEssentiaCell1k;
    }

    @Override
    public IItemDefinition essentiaCell4k() {
        return this.itemEssentiaCell4k;
    }

    @Override
    public IItemDefinition essentiaCell16k() {
        return this.itemEssentiaCell16k;
    }

    @Override
    public IItemDefinition essentiaCell64k() {
        return this.itemEssentiaCell64k;
    }

    @Override
    public IItemDefinition essentiaCellCreative() {
        return this.itemEssentiaCellCreative;
    }

    @Override
    public IItemDefinition essentiaImportBus() {
        return this.itemEssentiaImportBus;
    }

    @Override
    public IItemDefinition essentiaExportBus() {
        return this.itemEssentiaExportBus;
    }

    @Override
    public IItemDefinition essentiaStorageBus() {
        return this.itemEssentiaStorageBus;
    }

    @Override
    public IItemDefinition essentiaTerminal() {
        return this.itemEssentiaTerminal;
    }

    @Override
    public IItemDefinition arcaneTerminal() {
        return this.itemArcaneTerminal;
    }

    @Override
    public IItemDefinition diffusionCore() {
        return this.itemDiffusionCore;
    }

    @Override
    public IItemDefinition coalescenceCore() {
        return this.itemCoalescenceCore;
    }

    @Override
    public IItemDefinition essentiaComponent1k() {
        return this.itemEssentiaComponent1k;
    }

    @Override
    public IItemDefinition essentiaComponent4k() {
        return this.itemEssentiaComponent4k;
    }

    @Override
    public IItemDefinition essentiaComponent16k() {
        return this.itemEssentiaComponent16k;
    }

    @Override
    public IItemDefinition essentiaComponent64k() {
        return this.itemEssentiaComponent64k;
    }

    @Override
    public IItemDefinition upgradeArcane() {
        return this.itemUpgradeArcane;
    }

    @Override
    public IItemDefinition dummyAspect() {
        return this.itemDummyAspect;
    }
}

