/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.altar.BloodAltar;
import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

@RitualRegister(value="eternal_soul")
public class RitualEternalSoul
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    private BlockPos altarOffsetPos = new BlockPos(0, 0, 0);

    public RitualEternalSoul() {
        super("ritualEternalSoul", 2, 2000000, "ritual.bloodmagic.eternalSoulRitual");
        this.addBlockRange(ALTAR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        UUID owner = masterRitualStone.getOwner();
        int currentEssence = NetworkHelper.getSoulNetwork(owner).getCurrentEssence();
        World world = masterRitualStone.getWorldObj();
        BlockPos pos = masterRitualStone.getBlockPos();
        BlockPos altarPos = pos.func_177971_a((Vec3i)this.altarOffsetPos);
        TileEntity tile = world.func_175625_s(altarPos);
        AreaDescriptor altarRange = masterRitualStone.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof TileAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof TileAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.func_177973_b((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        if (!(tile instanceof TileAltar)) {
            return;
        }
        BloodAltar altar = (BloodAltar)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        int horizontalRange = 15;
        int verticalRange = 20;
        List list = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)pos.func_177958_n() - 0.5f), (double)((float)pos.func_177956_o() - 0.5f), (double)((float)pos.func_177952_p() - 0.5f), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)).func_72321_a((double)horizontalRange, (double)verticalRange, (double)horizontalRange).func_72321_a(0.0, (double)(-verticalRange), 0.0));
        EntityPlayer entityOwner = PlayerHelper.getPlayerFromUUID(owner);
        int fillAmount = Math.min(currentEssence / 2, altar.fill(new FluidStack(BlockLifeEssence.getLifeEssence(), 10000), false));
        altar.fill(new FluidStack(BlockLifeEssence.getLifeEssence(), fillAmount), true);
        if (entityOwner != null && list.contains(entityOwner) && entityOwner.func_110143_aJ() > 2.0f && fillAmount != 0) {
            entityOwner.func_70606_j(2.0f);
        }
        for (EntityPlayer player : list) {
            player.func_70690_d(new PotionEffect(RegistrarBloodMagic.SOUL_FRAY, 100));
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(fillAmount * 2));
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        int i;
        this.addCornerRunes(components, 1, 0, EnumRuneType.FIRE);
        for (i = 0; i < 4; ++i) {
            this.addCornerRunes(components, 2, i, EnumRuneType.AIR);
        }
        this.addCornerRunes(components, 4, 1, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 4, 1, EnumRuneType.EARTH);
        for (i = 0; i < 2; ++i) {
            this.addCornerRunes(components, 4, i + 2, EnumRuneType.WATER);
        }
        this.addCornerRunes(components, 4, 4, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 6, 5, 0, EnumRuneType.FIRE);
        for (i = 0; i < 2; ++i) {
            this.addCornerRunes(components, 6, i, EnumRuneType.FIRE);
        }
        for (i = 0; i < 3; ++i) {
            this.addCornerRunes(components, 6, i + 2, EnumRuneType.BLANK);
        }
        this.addCornerRunes(components, 6, 5, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualEternalSoul();
    }
}

