/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.inversion;

import WayofTime.bloodmagic.soul.EnumDemonWillType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class CorruptionHandler {
    public static Map<Pair<Block, Integer>, Map<EnumDemonWillType, IBlockState>> corruptBlockMap = new HashMap<Pair<Block, Integer>, Map<EnumDemonWillType, IBlockState>>();

    public static void registerBlockCorruption(EnumDemonWillType type, Block block, int meta, IBlockState corruptedState) {
        Pair pair = Pair.of((Object)block, (Object)meta);
        if (corruptBlockMap.containsKey(pair)) {
            Map<EnumDemonWillType, IBlockState> stateMap = corruptBlockMap.get(pair);
            stateMap.put(type, corruptedState);
        } else {
            HashMap<EnumDemonWillType, IBlockState> stateMap = new HashMap<EnumDemonWillType, IBlockState>();
            stateMap.put(type, corruptedState);
            corruptBlockMap.put((Pair<Block, Integer>)pair, stateMap);
        }
    }

    public static boolean isBlockCorruptible(World world, EnumDemonWillType type, BlockPos pos, IBlockState state, Block block) {
        int meta = block.func_176201_c(state);
        Pair pair = Pair.of((Object)block, (Object)meta);
        if (corruptBlockMap.containsKey(pair)) {
            Map<EnumDemonWillType, IBlockState> stateMap = corruptBlockMap.get(pair);
            return stateMap.containsKey(type);
        }
        return false;
    }

    public static boolean corruptBlock(World world, EnumDemonWillType type, BlockPos pos, IBlockState state, Block block) {
        Map<EnumDemonWillType, IBlockState> stateMap;
        int meta = block.func_176201_c(state);
        Pair pair = Pair.of((Object)block, (Object)meta);
        if (corruptBlockMap.containsKey(pair) && (stateMap = corruptBlockMap.get(pair)).containsKey(type)) {
            return world.func_175656_a(pos, stateMap.get(type));
        }
        return false;
    }

    public static boolean corruptSurroundingBlocks(World world, EnumDemonWillType type, BlockPos centerPos, int radius, double featheringChance, double featheringDepth) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    if ((double)(i * i + j * j + k * k) > ((double)radius + 0.5) * ((double)radius + 0.5) || featheringChance > 0.0 && (double)(i * i + j * j + k * k) > ((double)radius - featheringDepth + 0.5) * ((double)radius - featheringDepth + 0.5) && world.field_73012_v.nextDouble() < featheringChance || world.func_175623_d(centerPos)) continue;
                    BlockPos offsetPos = centerPos.func_177982_a(i, j, k);
                    IBlockState offsetState = world.func_180495_p(offsetPos);
                    Block offsetBlock = offsetState.func_177230_c();
                    CorruptionHandler.corruptBlock(world, type, offsetPos, offsetState, offsetBlock);
                }
            }
        }
        return false;
    }
}

