/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.projectile;

import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityBloodLight
extends EntityThrowable
implements IThrowableEntity,
IEntityAdditionalSpawnData {
    public EntityLivingBase shootingEntity;
    protected int field_70195_i = 0;
    protected int maxTicksInAir = 600;

    public EntityBloodLight(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBloodLight(World world, double x, double y, double z) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
    }

    public EntityBloodLight(World world, EntityLivingBase player) {
        super(world, player);
        this.shootingEntity = player;
        float par3 = 0.8f;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.2;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, par3 * 1.5f, 1.0f);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70186_c(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.func_76133_a((double)(var1 * var1 + var3 * var3 + var5 * var5));
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        this.field_70159_w = var1 *= (double)var7;
        this.field_70181_x = var3 *= (double)var7;
        this.field_70179_y = var5 *= (double)var7;
        float var10 = MathHelper.func_76133_a((double)(var1 * var1 + var5 * var5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(var3, var10) * 180.0 / Math.PI);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.maxTicksInAir) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g != null) {
            if (mop.field_72308_g == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.field_72308_g);
        } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            EnumFacing sideHit = mop.field_178784_b;
            BlockPos blockPos = mop.func_178782_a().func_177972_a(sideHit);
            if (this.func_130014_f_().func_175623_d(blockPos)) {
                this.func_130014_f_().func_175656_a(blockPos, RegistrarBloodMagicBlocks.BLOOD_LIGHT.func_176223_P());
            }
        }
        this.func_70106_y();
    }

    protected void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.field_70195_i > 3) {
            this.shootingEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.shootingEntity), 1.0f);
            this.func_70106_y();
        } else if (mop instanceof EntityLivingBase) {
            ((EntityLivingBase)mop).func_70604_c(this.shootingEntity);
            this.doDamage(1, mop);
        }
        if (this.func_130014_f_().func_175623_d(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v))) {
            this.func_130014_f_().func_175656_a(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), Blocks.field_150480_ab.func_176223_P());
        }
        this.func_70106_y();
    }

    protected void doDamage(int i, Entity mop) {
        mop.func_70097_a(this.getDamageSource(), (float)i);
    }

    public DamageSource getDamageSource() {
        return DamageSource.func_76358_a((EntityLivingBase)this.shootingEntity);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.field_70195_i);
    }

    public void readSpawnData(ByteBuf data) {
        this.field_70195_i = data.readByte();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("projectileTicksInAir", this.field_70195_i);
        nbt.func_74768_a("projectileMaxTicksInAir", this.maxTicksInAir);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70195_i = nbt.func_74762_e("projectileTicksInAir");
        this.maxTicksInAir = nbt.func_74762_e("projectileMaxTicksInAir");
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.shootingEntity = (EntityLivingBase)entity;
        }
    }
}

