/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.core.registry;

import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.recipe.LivingArmourDowngradeRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class LivingArmourDowngradeRecipeRegistry {
    private static List<LivingArmourDowngradeRecipe> recipeList = new ArrayList<LivingArmourDowngradeRecipe>();
    private static Map<ItemStack, Map<Integer, List<ITextComponent>>> dialogueMap = new HashMap<ItemStack, Map<Integer, List<ITextComponent>>>();

    public static void registerRecipe(LivingArmourDowngradeRecipe recipe) {
        recipeList.add(recipe);
    }

    public static void registerDialog(ItemStack keyStack, Map<Integer, List<ITextComponent>> map) {
        dialogueMap.put(keyStack, map);
    }

    public static List<ITextComponent> getDialogForProcessTick(ItemStack keyStack, int tick) {
        for (Map.Entry<ItemStack, Map<Integer, List<ITextComponent>>> entry : dialogueMap.entrySet()) {
            Map<Integer, List<ITextComponent>> map;
            ItemStack key = entry.getKey();
            if (!OreDictionary.itemMatches((ItemStack)key, (ItemStack)keyStack, (boolean)false) || !(map = entry.getValue()).containsKey(tick)) continue;
            return map.get(tick);
        }
        return null;
    }

    public static void registerRecipe(LivingArmourUpgrade upgrade, ItemStack keyStack, Object ... recipe) {
        LivingArmourDowngradeRecipeRegistry.registerRecipe(new LivingArmourDowngradeRecipe(upgrade, keyStack, recipe));
    }

    public static LivingArmourDowngradeRecipe getMatchingRecipe(ItemStack keyStack, List<ItemStack> itemList, World world, BlockPos pos) {
        for (LivingArmourDowngradeRecipe recipe : recipeList) {
            if (!recipe.matches(keyStack, itemList, world, pos)) continue;
            return recipe;
        }
        return null;
    }

    public static List<LivingArmourDowngradeRecipe> getRecipeList() {
        return new ArrayList<LivingArmourDowngradeRecipe>(recipeList);
    }
}

