/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compress;

import WayofTime.bloodmagic.compress.CompressionHandler;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CompressionRegistry {
    private static List<CompressionHandler> compressionRegistry = new ArrayList<CompressionHandler>();
    public static Map<ItemStack, Integer> thresholdMap = new HashMap<ItemStack, Integer>();
    static Map<ItemStack, Tuple<ItemStack, Integer>> compressionMap = new HashMap<ItemStack, Tuple<ItemStack, Integer>>();

    public static void registerHandler(CompressionHandler handler) {
        compressionRegistry.add(handler);
    }

    public static void registerItemThreshold(ItemStack stack, int threshold) {
        thresholdMap.put(stack, threshold);
    }

    public static ItemStack compressInventory(ItemStack[] inv, World world) {
        for (CompressionHandler handler : compressionRegistry) {
            ItemStack stack = handler.compressInventory(inv, world);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return null;
    }

    public static Pair<ItemStack, Boolean> compressInventory(TileEntity tile, World world) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack[] inventory = new ItemStack[itemHandler.getSlots()];
            ItemStack[] copyInventory = new ItemStack[itemHandler.getSlots()];
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                inventory[slot] = itemHandler.extractItem(slot, 64, true);
                copyInventory[slot] = inventory[slot].func_77946_l();
            }
            for (CompressionHandler handler : compressionRegistry) {
                ItemStack stack = handler.compressInventory(copyInventory, world);
                if (stack.func_190926_b()) continue;
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    if (inventory[slot] == null || ItemStack.func_77989_b((ItemStack)inventory[slot], (ItemStack)copyInventory[slot])) continue;
                    itemHandler.extractItem(slot, inventory[slot].func_190916_E(), false);
                    if (copyInventory[slot] == null) continue;
                    itemHandler.insertItem(slot, copyInventory[slot], false);
                }
                return Pair.of((Object)Utils.insertStackIntoTile(stack, itemHandler), (Object)true);
            }
        }
        return Pair.of((Object)ItemStack.field_190927_a, (Object)false);
    }

    public static int getItemThreshold(ItemStack stack, int needed) {
        Integer threshold = thresholdMap.get(stack);
        if (threshold != null) {
            return threshold;
        }
        return stack.func_77976_d() - needed;
    }

    public static int getItemThreshold(ItemStack stack) {
        Integer threshold = thresholdMap.get(stack);
        if (threshold != null) {
            return threshold;
        }
        return stack.func_77976_d();
    }

    public static boolean areItemStacksEqual(ItemStack stack, ItemStack compressedStack) {
        return stack.func_77969_a(compressedStack) && (stack.func_77978_p() == null ? !compressedStack.func_77942_o() : stack.func_77978_p().equals((Object)compressedStack.func_77978_p()));
    }
}

