/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.waila.provider;

import WayofTime.bloodmagic.tile.TileBloodTank;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class DataProviderBloodTank
implements IWailaDataProvider {
    public static final IWailaDataProvider INSTANCE = new DataProviderBloodTank();

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("bloodmagic.bloodTank") && !config.getConfig("capability.tankinfo")) {
            return currenttip;
        }
        currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.tier", accessor.getNBTData().func_74762_e("tier")));
        currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.fluid.capacity", accessor.getNBTData().func_74762_e("capacity")));
        if (accessor.getNBTData().func_74764_b("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)accessor.getNBTData().func_74775_l("fluid"));
            currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.fluid.type", fluidStack.getLocalizedName()));
            currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.fluid.amount", fluidStack.amount, accessor.getNBTData().func_74762_e("capacity")));
        }
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        TileBloodTank tank = (TileBloodTank)te;
        tag.func_74768_a("tier", tank.func_145832_p() + 1);
        tag.func_74768_a("capacity", tank.capacity);
        if (tank.getTank().getFluid() != null) {
            tag.func_74782_a("fluid", (NBTBase)tank.getTank().getFluid().writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }
}

