/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.render.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyCircleRenderer;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MobSacrificeAlchemyCircleRenderer
extends AlchemyCircleRenderer {
    private ResourceLocation bottomArrayResource = new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/MovementArray.png");
    private ResourceLocation mobSacrificeSwirlResource = new ResourceLocation("bloodmagic", "textures/models/mobsacrificeswirl.png");

    public MobSacrificeAlchemyCircleRenderer(ResourceLocation location) {
        super(location);
    }

    public MobSacrificeAlchemyCircleRenderer() {
        this(new ResourceLocation("bloodmagic", "textures/models/AlchemyArrays/mobsacrifice.png"));
    }

    @Override
    public float getSizeModifier(float craftTime) {
        if (craftTime < 40.0f) {
            return 0.0f;
        }
        if (craftTime > 40.0f && craftTime < 100.0f) {
            return (craftTime - 40.0f) / 60.0f;
        }
        return 1.0f;
    }

    @Override
    public float getRotation(float craftTime) {
        float offset = 50.0f;
        if (craftTime >= offset) {
            float modifier = (craftTime - offset) * 5.0f;
            return modifier * 1.0f;
        }
        return 0.0f;
    }

    @Override
    public float getSecondaryRotation(float craftTime) {
        return 0.0f;
    }

    @Override
    public void renderAt(TileEntity tile, double x, double y, double z, float craftTime) {
        if (!(tile instanceof TileAlchemyArray)) {
            return;
        }
        TileAlchemyArray tileArray = (TileAlchemyArray)tile;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float rot = this.getRotation(craftTime);
        float size = 1.0f * this.getSizeModifier(craftTime);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arrayResource);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        EnumFacing sideHit = EnumFacing.UP;
        EnumFacing rotation = tileArray.getRotation();
        GlStateManager.func_179109_b((float)((float)sideHit.func_82601_c() * this.offsetFromFace), (float)((float)sideHit.func_96559_d() * this.offsetFromFace), (float)((float)sideHit.func_82599_e() * this.offsetFromFace));
        switch (sideHit) {
            case DOWN: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)this.getVerticalOffset(craftTime));
        GlStateManager.func_179094_E();
        double topHeightOffset = 0.0;
        double middleHeightOffset = 0.0;
        double bottomHeightOffset = 0.0;
        BlockPos pos = tileArray.func_174877_v();
        World world = tileArray.func_145831_w();
        for (int i = 1; i <= 3; ++i) {
            GlStateManager.func_179094_E();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.bottomArrayResource);
            this.translateAndRotateFloatingArray(tessellator, wr, size, rot, craftTime, i);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.arrayResource);
        this.renderStandardCircle(tessellator, wr, 3.0);
        GlStateManager.func_179121_F();
        float swirlSize = 3.0f;
        if (craftTime <= 40.0f) {
            swirlSize = 0.0f;
        } else if (craftTime <= 100.0f) {
            swirlSize = 3.0f * (craftTime - 40.0f) / 60.0f;
        }
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.mobSacrificeSwirlResource);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
        GlStateManager.func_179114_b((float)(rot / 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderStandardCircle(tessellator, wr, swirlSize);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public float getStartupPitchYawRatio(float craftTime) {
        if (craftTime <= 80.0f) {
            return 0.0f;
        }
        if (craftTime > 80.0f && craftTime < 140.0f) {
            return (craftTime - 80.0f) / 60.0f;
        }
        return 1.0f;
    }

    private void translateAndRotateFloatingArray(Tessellator tessellator, BufferBuilder builder, double size, float rotation, float craftTime, int circle) {
        double verticalOffset = 2.0;
        float primaryRotation = 0.0f;
        float secondaryRotation = 0.0f;
        if (craftTime >= 40.0f) {
            primaryRotation = (craftTime - 40.0f) * 4.0f;
            secondaryRotation = (craftTime - 40.0f) * 2.0f;
        }
        float translationOffset = 1.0f;
        if (craftTime < 80.0f) {
            translationOffset = 0.0f;
        } else if (craftTime < 140.0f) {
            translationOffset = (craftTime - 80.0f) / 60.0f;
        }
        switch (circle) {
            case 1: {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-verticalOffset));
                GlStateManager.func_179114_b((float)(rotation / 200.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(rotation / 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)(1.7 * (double)translationOffset), (double)0.0, (double)0.0);
                break;
            }
            case 2: {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-verticalOffset));
                GlStateManager.func_179114_b((float)(rotation / 150.0f + 120.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)120.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-rotation / 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)(1.2 * (double)translationOffset), (double)0.0, (double)0.0);
                break;
            }
            case 3: {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-verticalOffset));
                GlStateManager.func_179114_b((float)(rotation / 100.0f + 284.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)240.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-rotation / 7.0f + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(2.0f * translationOffset), (float)0.0f, (float)0.0f);
                break;
            }
        }
        GlStateManager.func_179114_b((float)primaryRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)secondaryRotation, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(secondaryRotation * 0.41831f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderStandardCircle(tessellator, builder, size);
    }

    private void renderStandardCircle(Tessellator tessellator, BufferBuilder builder, double size) {
        double var31 = 0.0;
        double var33 = 1.0;
        double var35 = 0.0;
        double var37 = 1.0;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(size / 2.0, size / 2.0, 0.0).func_187315_a(var33, var37).func_181675_d();
        builder.func_181662_b(size / 2.0, -size / 2.0, 0.0).func_187315_a(var33, var35).func_181675_d();
        builder.func_181662_b(-size / 2.0, -size / 2.0, 0.0).func_187315_a(var31, var35).func_181675_d();
        builder.func_181662_b(-size / 2.0, size / 2.0, 0.0).func_187315_a(var31, var37).func_181675_d();
        tessellator.func_78381_a();
    }
}

