/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.altar;

import WayofTime.bloodmagic.altar.AltarComponent;
import WayofTime.bloodmagic.altar.AltarTier;
import WayofTime.bloodmagic.altar.AltarUpgrade;
import WayofTime.bloodmagic.altar.ComponentType;
import WayofTime.bloodmagic.altar.IAltarComponent;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.block.BlockBloodRune;
import WayofTime.bloodmagic.tile.TileAltar;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class AltarUtil {
    @Nonnull
    public static AltarTier getTier(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileAltar)) {
            return AltarTier.ONE;
        }
        AltarTier lastCheck = AltarTier.ONE;
        for (AltarTier tier : AltarTier.values()) {
            for (AltarComponent component : tier.getAltarComponents()) {
                List<IBlockState> validStates;
                BlockPos componentPos = pos.func_177971_a((Vec3i)component.getOffset());
                IBlockState worldState = world.func_180495_p(componentPos);
                if (worldState.func_177230_c() instanceof IAltarComponent && ((IAltarComponent)worldState.func_177230_c()).getType(world, worldState, componentPos) == component.getComponent() || component.getComponent() == ComponentType.NOTAIR && worldState.func_185904_a() != Material.field_151579_a && !worldState.func_185904_a().func_76224_d() || (validStates = BloodMagicAPI.INSTANCE.getComponentStates(component.getComponent())).contains(worldState)) continue;
                return lastCheck;
            }
            lastCheck = tier;
        }
        return lastCheck;
    }

    @Nonnull
    public static AltarUpgrade getUpgrades(World world, BlockPos pos, AltarTier currentTier) {
        AltarUpgrade upgrades = new AltarUpgrade();
        for (AltarComponent component : currentTier.getAltarComponents()) {
            BlockPos componentPos;
            IBlockState state;
            if (!component.isUpgradeSlot() || component.getComponent() != ComponentType.BLOODRUNE || !((state = world.func_180495_p(componentPos = pos.func_177971_a((Vec3i)component.getOffset()))).func_177230_c() instanceof BlockBloodRune)) continue;
            upgrades.upgrade(((BlockBloodRune)state.func_177230_c()).getBloodRune((IBlockAccess)world, componentPos, state));
        }
        return upgrades;
    }

    @Nullable
    public static Pair<BlockPos, ComponentType> getFirstMissingComponent(World world, BlockPos pos, int altarTier) {
        if (altarTier >= AltarTier.MAXTIERS) {
            return null;
        }
        for (AltarTier tier : AltarTier.values()) {
            for (AltarComponent component : tier.getAltarComponents()) {
                List<IBlockState> validStates;
                BlockPos componentPos = pos.func_177971_a((Vec3i)component.getOffset());
                IBlockState worldState = world.func_180495_p(componentPos);
                if (component.getComponent() == ComponentType.NOTAIR && worldState.func_185904_a() != Material.field_151579_a && !worldState.func_185904_a().func_76224_d() || (validStates = BloodMagicAPI.INSTANCE.getComponentStates(component.getComponent())).contains(worldState)) continue;
                return Pair.of((Object)componentPos, (Object)((Object)component.getComponent()));
            }
        }
        return null;
    }
}

