/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.util.DamageSourceBloodMagic;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AlchemyArrayEffectFurnaceFuel
extends AlchemyArrayEffect {
    static double radius = 10.0;
    static int burnTicksAdded = 401;

    public AlchemyArrayEffectFurnaceFuel(String key) {
        super(key);
    }

    @Override
    public boolean update(TileEntity tile, int ticksActive) {
        BlockPos pos = tile.func_174877_v();
        World world = tile.func_145831_w();
        EntityPlayer sacrifice = null;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            TileEntityFurnace furnaceTile;
            TileEntity bottomTile;
            BlockPos furnacePos = pos.func_177972_a(face);
            Block block = world.func_180495_p(furnacePos).func_177230_c();
            if (block != Blocks.field_150460_al || !((bottomTile = world.func_175625_s(furnacePos)) instanceof TileEntityFurnace) || !AlchemyArrayEffectFurnaceFuel.canFurnaceSmelt(furnaceTile = (TileEntityFurnace)bottomTile) || furnaceTile.func_145950_i()) continue;
            if (sacrifice == null || sacrifice.field_70128_L) {
                AxisAlignedBB bb = new AxisAlignedBB(pos).func_186662_g(radius);
                List playerList = world.func_72872_a(EntityPlayer.class, bb);
                for (EntityPlayer player : playerList) {
                    if (player.field_70128_L) continue;
                    sacrifice = player;
                }
            }
            if (sacrifice == null || sacrifice.field_70128_L) {
                return false;
            }
            if (!AlchemyArrayEffectFurnaceFuel.addFuelTime(furnaceTile, world, furnacePos, burnTicksAdded) || sacrifice.field_71075_bZ.field_75098_d) continue;
            sacrifice.field_70172_ad = 0;
            sacrifice.func_70097_a((DamageSource)DamageSourceBloodMagic.INSTANCE, 1.0f);
        }
        return false;
    }

    public static boolean addFuelTime(TileEntityFurnace furnaceTile, World world, BlockPos furnacePos, int cookTime) {
        furnaceTile.func_174885_b(0, cookTime);
        BlockFurnace.func_176446_a((boolean)true, (World)world, (BlockPos)furnacePos);
        return true;
    }

    public static boolean canFurnaceSmelt(TileEntityFurnace furnaceTile) {
        ItemStack burnStack = furnaceTile.func_70301_a(0);
        if (burnStack.func_190926_b()) {
            return false;
        }
        ItemStack resultStack = FurnaceRecipes.func_77602_a().func_151395_a(burnStack);
        if (resultStack.func_190926_b()) {
            return false;
        }
        ItemStack finishStack = furnaceTile.func_70301_a(2);
        if (finishStack.func_190926_b()) {
            return true;
        }
        if (!finishStack.func_77969_a(resultStack)) {
            return false;
        }
        if (finishStack.func_190916_E() + resultStack.func_190916_E() <= furnaceTile.func_70297_j_() && finishStack.func_190916_E() + resultStack.func_190916_E() <= finishStack.func_77976_d()) {
            return true;
        }
        return finishStack.func_190916_E() + resultStack.func_190916_E() <= resultStack.func_77976_d();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectFurnaceFuel(this.key);
    }
}

