/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad.packet;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.machines.machine.teleport.telepad.TileTelePad;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketOpenServerGui
extends MessageTileEntity<TileTelePad> {
    int id;

    public PacketOpenServerGui() {
    }

    public PacketOpenServerGui(@Nonnull TileTelePad te, int guiId) {
        super((TileEntity)te);
        this.id = guiId;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.id = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketOpenServerGui, IMessage> {
        public IMessage onMessage(PacketOpenServerGui message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = message.getWorld(ctx);
            TileTelePad te = (TileTelePad)message.getTileEntity(world);
            if (te != null) {
                if (message.id == 1 && !te.canUiBeAccessed((EntityPlayer)player)) {
                    BlockTravelAnchor.sendPrivateStatusMessage(world, (EntityPlayer)player, te.getOwner());
                } else {
                    MachineObject.block_tele_pad.openGui(world, te.func_174877_v(), (EntityPlayer)player, null, message.id);
                }
            }
            return null;
        }
    }
}

