/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.anchor;

import com.enderio.core.common.util.UserIdent;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.base.machine.base.block.AbstractMachineBlock;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IDefaultRenderers;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.teleport.ContainerTravelAccessable;
import crazypants.enderio.machines.machine.teleport.ContainerTravelAuth;
import crazypants.enderio.machines.machine.teleport.GuiTravelAccessable;
import crazypants.enderio.machines.machine.teleport.GuiTravelAuth;
import crazypants.enderio.machines.machine.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.machines.machine.teleport.anchor.TravelEntitySpecialRenderer;
import crazypants.enderio.machines.machine.teleport.telepad.render.TelePadRenderMapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTravelAnchor<T extends TileTravelAnchor>
extends AbstractMachineBlock<T>
implements IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint,
IDefaultRenderers,
IHaveTESR {
    protected static final int GUI_ID_TRAVEL_ACCESSABLE = 0;

    public static BlockTravelAnchor<TileTravelAnchor> create(@Nonnull IModObject modObject) {
        BlockTravelAnchor<TileTravelAnchor> result = new BlockTravelAnchor<TileTravelAnchor>(modObject);
        result.init();
        return result;
    }

    protected BlockTravelAnchor(@Nonnull IModObject mo) {
        super(mo);
        this.setShape(this.mkShape(BlockFaceShape.BOWL));
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull T tileEntity) {
        blockStateWrapper.addCacheKey(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return TelePadRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return TelePadRenderMapper.instance;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, boolean willHarvest) {
        TileTravelAnchor te = (TileTravelAnchor)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            if (te.getOwner().equals(UserIdent.create((GameProfile)entityPlayer.func_146103_bH())) || te.getAccessMode() == ITravelAccessable.AccessMode.PUBLIC || entityPlayer.func_184812_l_() && !willHarvest) {
                return super.removedByPlayer(state, world, pos, entityPlayer, willHarvest);
            }
            if (!world.field_72995_K) {
                entityPlayer.func_146105_b((ITextComponent)Lang.GUI_AUTH_ERROR_HARVEST.toChatServer(te.getOwner().getPlayerName()), true);
            }
        }
        return false;
    }

    @Override
    protected boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumFacing side) {
        TileTravelAnchor te = (TileTravelAnchor)this.getTileEntity((IBlockAccess)world, pos);
        if (!world.field_72995_K && te != null) {
            if (te.canUiBeAccessed(entityPlayer)) {
                return this.openGui(world, pos, entityPlayer, side, 0);
            }
            BlockTravelAnchor.sendPrivateStatusMessage(world, entityPlayer, te.getOwner());
        }
        return true;
    }

    public static void sendPrivateStatusMessage(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull UserIdent owner) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            player.func_146105_b((ITextComponent)Lang.GUI_AUTH_ERROR_PRIVATE.toChatServer(owner.getPlayerName()), true);
        }
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int ID, @Nonnull T te) {
        if (0 == ID) {
            return new ContainerTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world, 0);
        }
        return new ContainerTravelAuth(player.field_71071_by);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int ID, @Nonnull T te) {
        if (0 == ID) {
            return new GuiTravelAccessable<T>(player.field_71071_by, new ContainerTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world, ID), te, world);
        }
        return new GuiTravelAuth(player, (ITravelAccessable)te, world);
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileTravelAnchor.class, new TravelEntitySpecialRenderer());
    }
}

