/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.spawner;

import com.enderio.core.client.render.BoundingBox;
import crazypants.enderio.machines.config.config.SpawnerConfig;
import crazypants.enderio.machines.machine.spawner.SpawnerNotification;
import crazypants.enderio.util.CapturedMob;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SpawnerLogic {
    @Nonnull
    private final ISpawnerCallback spawner;

    public SpawnerLogic(@Nonnull ISpawnerCallback spawner) {
        this.spawner = spawner;
    }

    public boolean isAreaClear() {
        return this.isAreaClear(this.spawner.getRange(), 2, (Integer)SpawnerConfig.poweredSpawnerMaxNearbyEntities.get());
    }

    public boolean isAreaClear(int spawnRangeXZ, int spawnRangeY, int amount) {
        CapturedMob capturedMob;
        if (amount > 0 && (capturedMob = this.spawner.getEntity()) != null) {
            return this.isAreaClear(this.spawner.getSpawnerWorld(), capturedMob.getEntityClass(), spawnRangeXZ, spawnRangeY, amount);
        }
        return true;
    }

    private boolean isAreaClear(World world, Class<? extends Entity> entityClass, int spawnRangeXZ, int spawnRangeY, int amount) {
        if (amount > 0 && entityClass != null && world.func_175647_a(entityClass, (AxisAlignedBB)new BoundingBox(this.spawner.getSpawnerPos()).expand((double)spawnRangeXZ, (double)spawnRangeY, (double)spawnRangeXZ), EntitySelectors.field_94557_a).size() >= amount) {
            this.spawner.setNotification(SpawnerNotification.AREA_FULL);
            return false;
        }
        this.spawner.removeNotification(SpawnerNotification.AREA_FULL);
        return true;
    }

    public boolean trySpawnEntity() {
        CapturedMob capturedMob = this.spawner.getEntity();
        if (capturedMob == null) {
            return false;
        }
        World world = this.spawner.getSpawnerWorld();
        int spawnRange = this.spawner.getRange();
        Class<? extends Entity> entityClass = capturedMob.getEntityClass();
        if (!this.isAreaClear(world, entityClass, spawnRange, 2, (Integer)SpawnerConfig.poweredSpawnerMaxNearbyEntities.get())) {
            return false;
        }
        if (!EntityLiving.class.isAssignableFrom(entityClass)) {
            this.spawner.setNotification(SpawnerNotification.BAD_SOUL);
            return false;
        }
        BlockPos pos = this.spawner.getSpawnerPos();
        EntityLiving entity = (EntityLiving)this.createEntity(world.func_175649_E(pos), true);
        if (entity == null) {
            this.spawner.setNotification(SpawnerNotification.BAD_SOUL);
            return false;
        }
        for (int i = 0; i < (Integer)SpawnerConfig.poweredSpawnerMaxSpawnTries.get(); ++i) {
            double x = (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)spawnRange;
            double y = pos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
            double z = (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)spawnRange;
            entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.canSpawnEntity(entity)) continue;
            if (entity instanceof EntityCreature) {
                this.spawner.setHome((EntityCreature)entity);
            }
            world.func_72838_d((Entity)entity);
            world.func_175718_b(2004, pos, 0);
            entity.func_70656_aK();
            this.addDependends(world, entity);
            return true;
        }
        this.cleanupUnspawnedEntity((Entity)entity);
        this.spawner.setNotification(SpawnerNotification.NO_LOCATION_FOUND);
        return false;
    }

    private void addDependends(@Nonnull World world, @Nonnull EntityLiving entity) {
        Entity ridingEntity = entity.func_184187_bx();
        if (ridingEntity != null) {
            ridingEntity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
            if (ridingEntity instanceof EntityCreature) {
                this.spawner.setHome((EntityCreature)ridingEntity);
            }
            if (!ridingEntity.isAddedToWorld()) {
                world.func_72838_d(ridingEntity);
            }
        }
        for (Entity passenger : entity.func_184188_bt()) {
            passenger.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
            if (passenger instanceof EntityCreature) {
                this.spawner.setHome((EntityCreature)passenger);
            }
            if (passenger.isAddedToWorld()) continue;
            world.func_72838_d(passenger);
        }
    }

    public boolean anyLocationInRange() {
        BlockPos pos;
        World world = this.spawner.getSpawnerWorld();
        Entity entity = this.createEntity(world.func_175649_E(pos = this.spawner.getSpawnerPos()), true);
        if (!(entity instanceof EntityLiving)) {
            this.cleanupUnspawnedEntity(entity);
            this.spawner.setNotification(SpawnerNotification.BAD_SOUL);
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        int spawnRange = this.spawner.getRange();
        int minxi = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + (0.0 - Math.nextAfter(1.0, 0.0)) * (double)spawnRange));
        int maxxi = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + (Math.nextAfter(1.0, 0.0) - 0.0) * (double)spawnRange));
        int minyi = pos.func_177956_o() + 0 - 1;
        int maxyi = pos.func_177956_o() + 2 - 1;
        int minzi = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + (0.0 - Math.nextAfter(1.0, 0.0)) * (double)spawnRange));
        int maxzi = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + (Math.nextAfter(1.0, 0.0) - 0.0) * (double)spawnRange));
        for (int x = minxi; x <= maxxi; ++x) {
            for (int y = minyi; y <= maxyi; ++y) {
                for (int z = minzi; z <= maxzi; ++z) {
                    entityliving.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, 0.0f, 0.0f);
                    if (!this.canSpawnEntity(entityliving)) continue;
                    this.cleanupUnspawnedEntity(entity);
                    this.spawner.removeNotification(SpawnerNotification.NO_LOCATION_AT_ALL);
                    return true;
                }
            }
        }
        this.cleanupUnspawnedEntity(entity);
        this.spawner.setNotification(SpawnerNotification.NO_LOCATION_AT_ALL);
        return false;
    }

    private void cleanupUnspawnedEntity(Entity entity) {
        if (entity != null) {
            entity.func_70106_y();
            Entity ridingEntity = entity.func_184187_bx();
            if (ridingEntity != null) {
                ridingEntity.func_70106_y();
            }
            for (Entity passenger : entity.func_184188_bt()) {
                passenger.func_70106_y();
            }
        }
    }

    @Nullable
    Entity createEntity(DifficultyInstance difficulty, boolean forceAlive) {
        CapturedMob capturedMob = this.spawner.getEntity();
        if (capturedMob == null) {
            return null;
        }
        Entity ent = capturedMob.getEntity(this.spawner.getSpawnerWorld(), this.spawner.getSpawnerPos(), difficulty, false);
        if (ent == null) {
            this.spawner.resetCapturedMob();
            return null;
        }
        if (forceAlive && (Integer)SpawnerConfig.poweredSpawnerMaxPlayerDistance.get() <= 0 && (Integer)SpawnerConfig.poweredSpawnerDespawnTimeSeconds.get() > 0 && ent instanceof EntityLiving) {
            ent.getEntityData().func_74772_a("spawnedByPoweredSpawner", this.spawner.getSpawnerWorld().func_82737_E());
            ((EntityLiving)ent).func_110163_bv();
        }
        return ent;
    }

    protected boolean canSpawnEntity(EntityLiving entityliving) {
        switch ((Boolean)SpawnerConfig.poweredSpawnerUseForgeSpawnChecks.get() != false ? ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)entityliving.field_70170_p, (float)((float)entityliving.field_70165_t), (float)((float)entityliving.field_70163_u), (float)((float)entityliving.field_70161_v), (boolean)true) : Event.Result.DEFAULT) {
            case ALLOW: {
                return true;
            }
            case DEFAULT: {
                if (((Boolean)SpawnerConfig.poweredSpawnerUseVanillaSpawnChecks.get()).booleanValue()) {
                    return entityliving.func_70601_bi() && entityliving.func_70058_J();
                }
                return entityliving.func_70058_J();
            }
        }
        this.spawner.setNotification(SpawnerNotification.DENIED);
        return false;
    }

    public static interface ISpawnerCallback {
        @Nonnull
        public World getSpawnerWorld();

        @Nonnull
        public BlockPos getSpawnerPos();

        public int getRange();

        @Nonnull
        default public BoundingBox getBounds() {
            return new BoundingBox(this.getSpawnerPos()).expand((double)this.getRange(), 1.0, (double)this.getRange());
        }

        public void setNotification(@Nonnull SpawnerNotification var1);

        public void removeNotification(@Nonnull SpawnerNotification var1);

        @Nullable
        public CapturedMob getEntity();

        default public void setHome(@Nonnull EntityCreature entity) {
        }

        public void resetCapturedMob();
    }
}

