/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.AbstractPainterTemplate;
import crazypants.enderio.machines.integration.jei.PainterRecipeCategory;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PainterRegistryPlugin
implements IRecipeRegistryPlugin {
    private static final WrapperSorter SORTER = new WrapperSorter();
    @Nonnull
    private final NNList<ItemStack> VALID_TARGETS = new NNList();
    @Nonnull
    private final NNList<ItemStack> VALID_PAINTS = new NNList();
    @Nonnull
    private final NNList<ItemStack> SHORT_PAINTS = new NNList();
    @Nonnull
    private final List<PainterRecipeCategory.PainterRecipeWrapper> staticRecipes;
    @Nonnull
    private final IIngredientRegistry ingredientRegistry;

    private boolean contains(NNList<ItemStack> list, @Nullable ItemStack itemStack) {
        if (itemStack != null && !itemStack.func_190926_b()) {
            for (ItemStack thing : list) {
                if (!this.is(thing, itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean is(ItemStack stack0, ItemStack stack1) {
        return stack0.func_77973_b() == stack1.func_77973_b() && (!stack0.func_77981_g() || stack0.func_77952_i() == Short.MAX_VALUE || stack0.func_77952_i() == stack1.func_77952_i());
    }

    PainterRegistryPlugin(@Nonnull IModRegistry registry) {
        this.ingredientRegistry = registry.getIngredientRegistry();
        Collection validItems = this.ingredientRegistry.getAllIngredients(ItemStack.class);
        Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine("painter");
        block0: for (ItemStack itemStack : validItems) {
            if (itemStack == null) continue;
            for (IMachineRecipe rec : recipes.values()) {
                AbstractPainterTemplate recipe;
                if (!(rec instanceof AbstractPainterTemplate) || !(recipe = (AbstractPainterTemplate)rec).isValidTarget(itemStack)) continue;
                this.VALID_TARGETS.add((Object)itemStack);
                continue block0;
            }
        }
        this.SHORT_PAINTS.add((Object)new ItemStack(Items.field_151131_as));
        this.SHORT_PAINTS.add((Object)new ItemStack(Blocks.field_150348_b));
        this.SHORT_PAINTS.add((Object)new ItemStack((Block)Blocks.field_150328_O));
        this.staticRecipes = this.buildStaticRecipes();
    }

    private boolean isValidPaint(Map<String, IMachineRecipe> recipes, ItemStack itemStack) {
        if (itemStack != null) {
            if (this.contains(this.VALID_PAINTS, itemStack)) {
                return true;
            }
            if (recipes == null) {
                recipes = MachineRecipeRegistry.instance.getRecipesForMachine("painter");
            }
            for (IMachineRecipe rec : recipes.values()) {
                AbstractPainterTemplate recipe;
                if (!(rec instanceof AbstractPainterTemplate) || !(recipe = (AbstractPainterTemplate)rec).isPartialRecipe(itemStack, Prep.getEmpty())) continue;
                this.VALID_PAINTS.add((Object)itemStack);
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public <V> List<String> getRecipeCategoryUids(@Nonnull IFocus<V> focus) {
        Object value = focus.getValue();
        if (value instanceof ItemStack) {
            ItemStack stack = (ItemStack)value;
            if (focus.getMode() == IFocus.Mode.INPUT ? this.contains(this.VALID_TARGETS, stack) || this.isValidPaint(null, stack) : PaintUtil.isPainted(stack) && PaintUtil.hasPaintSource(stack)) {
                return Collections.singletonList("Painter");
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(@Nonnull IRecipeCategory<T> recipeCategory, @Nonnull IFocus<V> focus) {
        Object value;
        if (recipeCategory instanceof PainterRecipeCategory && (value = focus.getValue()) instanceof ItemStack) {
            ItemStack stack = ((ItemStack)value).func_77946_l();
            stack.func_190920_e(1);
            ArrayList<Object> list1 = new ArrayList<Object>();
            ArrayList<PainterRecipeCategory.PainterRecipeWrapper> list2 = new ArrayList<PainterRecipeCategory.PainterRecipeWrapper>();
            Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine("painter");
            if (focus.getMode() == IFocus.Mode.INPUT) {
                AbstractPainterTemplate recipe;
                if (this.contains(this.VALID_TARGETS, stack)) {
                    ItemStack target = stack;
                    for (IMachineRecipe rec : recipes.values()) {
                        if (!(rec instanceof AbstractPainterTemplate) || !(recipe = (AbstractPainterTemplate)rec).isValidTarget(target)) continue;
                        Object wrapper = new PainterRecipeCategory.PainterRecipeWrapper(recipe, target, new ArrayList<ItemStack>(), new ArrayList<ItemStack>());
                        for (ItemStack paint : this.ingredientRegistry.getAllIngredients(ItemStack.class)) {
                            if (this.is(target, paint) || paint == null || !recipe.isRecipe(paint, target)) continue;
                            wrapper.results.add(recipe.getCompletedResult(paint, target));
                            wrapper.paints.add(paint);
                        }
                        if (wrapper.results.isEmpty()) continue;
                        list1.add(wrapper);
                    }
                }
                if (this.isValidPaint(recipes, stack)) {
                    ItemStack paint = stack;
                    for (IMachineRecipe rec : recipes.values()) {
                        if (!(rec instanceof AbstractPainterTemplate)) continue;
                        recipe = (AbstractPainterTemplate)rec;
                        for (ItemStack target : this.VALID_TARGETS) {
                            if (this.is(target, paint) || target == null || !recipe.isRecipe(paint, target)) continue;
                            list2.add(new PainterRecipeCategory.PainterRecipeWrapper(recipe, target, paint, recipe.getCompletedResult(paint, target)));
                        }
                    }
                }
            } else if (PaintUtil.isPainted(stack) && PaintUtil.hasPaintSource(stack)) {
                ItemStack target = PaintUtil.getOriginalStack(stack);
                ItemStack paint = PaintUtil.getPaintSource(stack);
                for (IMachineRecipe rec : recipes.values()) {
                    AbstractPainterTemplate recipe;
                    if (!(rec instanceof AbstractPainterTemplate) || !(recipe = (AbstractPainterTemplate)rec).isRecipe(paint, target)) continue;
                    list1.add(new PainterRecipeCategory.PainterRecipeWrapper(recipe, target, paint, recipe.getCompletedResult(paint, target)));
                }
            }
            list1.sort(SORTER);
            list2.sort(SORTER);
            list1.addAll(list2);
            return list1;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(@Nonnull IRecipeCategory<T> recipeCategory) {
        if (recipeCategory instanceof PainterRecipeCategory) {
            return this.staticRecipes;
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<PainterRecipeCategory.PainterRecipeWrapper> buildStaticRecipes() {
        ArrayList<PainterRecipeCategory.PainterRecipeWrapper> list = new ArrayList<PainterRecipeCategory.PainterRecipeWrapper>();
        Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine("painter");
        for (IMachineRecipe rec : recipes.values()) {
            if (!(rec instanceof AbstractPainterTemplate)) continue;
            AbstractPainterTemplate recipe = (AbstractPainterTemplate)rec;
            for (ItemStack target : this.VALID_TARGETS) {
                if (target == null || !recipe.isValidTarget(target)) continue;
                for (ItemStack paint : this.SHORT_PAINTS) {
                    if (this.is(target, paint) || paint == null || !recipe.isRecipe(paint, target)) continue;
                    list.add(new PainterRecipeCategory.PainterRecipeWrapper(recipe, target, paint, recipe.getCompletedResult(paint, target)));
                }
            }
        }
        list.sort(SORTER);
        return list;
    }

    private static final class WrapperSorter
    implements Comparator<PainterRecipeCategory.PainterRecipeWrapper> {
        private WrapperSorter() {
        }

        @Override
        public int compare(PainterRecipeCategory.PainterRecipeWrapper o1, PainterRecipeCategory.PainterRecipeWrapper o2) {
            int compare = Integer.compare(Item.func_150891_b((Item)o1.target.func_77973_b()), Item.func_150891_b((Item)o2.target.func_77973_b()));
            if (compare == 0) {
                compare = Integer.compare(Item.func_150891_b((Item)o1.paints.get(0).func_77973_b()), Item.func_150891_b((Item)o2.paints.get(0).func_77973_b()));
            }
            return compare;
        }
    }
}

