/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic.fluids;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.integration.tic.fluids.MoltenRedstone;
import crazypants.enderio.integration.tic.queues.TicRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Redstone {
    private static final ResourceLocation TEX_STILL = new ResourceLocation("tconstruct:blocks/fluids/molten_metal_flow");
    private static final ResourceLocation TEX_FLOWING = new ResourceLocation("tconstruct:blocks/fluids/molten_metal");
    private static Fluid fluid;

    public static void createFluid() {
        fluid = new Fluid("redstone", TEX_FLOWING, TEX_STILL){

            public int getColor() {
                return -65536;
            }
        }.setUnlocalizedName("enderio.redstone").setDensity(1200).setTemperature(1973).setViscosity(1500);
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public static Block createFluidBlock() {
        fluid.setLuminosity(Blocks.field_150439_ay.func_176223_P().func_185906_d() * 7 / 10);
        MoltenRedstone block = new MoltenRedstone(fluid, Material.field_151586_h, 0xFF0000);
        block.setFluidStack(new FluidStack(FluidRegistry.getFluid((String)fluid.getName()), 1000));
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluid", fluid.getName());
        tag.func_74778_a("ore", "Redstone");
        tag.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        Fluids.registerFluidBlockRendering(fluid);
    }

    public static void registerRedstoneRecipes() {
        Fluid f = FluidRegistry.getFluid((String)"redstone");
        if (f != null) {
            TicRecipeHandler.instance.registerSmelterySmelting(new Things().add(Items.field_151137_ax), f, 100.0f);
            TicRecipeHandler.instance.registerSmelterySmelting(new Things().add(Blocks.field_150451_bX), f, 900.0f);
            TicRecipeHandler.instance.registerBasinCasting(new Things().add(Blocks.field_150451_bX), new Things(), f, 900);
        }
    }
}

