/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IExtractor;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.render.BakedQuadBuilder;
import crazypants.enderio.conduits.render.ConduitTexture;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderioconduits", value={Side.CLIENT})
public class ConduitInOutRenderer {
    @Nonnull
    public static final TextureRegistry.TextureSupplier ICON_BG = TextureRegistry.registerTexture("blocks/item_conduit_io_connector");
    @Nonnull
    public static final TextureRegistry.TextureSupplier ICON_IN = TextureRegistry.registerTexture("blocks/item_conduit_input");
    @Nonnull
    public static final TextureRegistry.TextureSupplier ICON_OUT = TextureRegistry.registerTexture("blocks/item_conduit_output");
    @Nonnull
    public static final TextureRegistry.TextureSupplier ICON_INOUT_IN = TextureRegistry.registerTexture("blocks/item_conduit_in_out_in");
    @Nonnull
    public static final TextureRegistry.TextureSupplier ICON_INOUT_OUT = TextureRegistry.registerTexture("blocks/item_conduit_in_out_out");

    @SubscribeEvent
    public static void load(EnderIOLifecycleEvent.PreInit event) {
    }

    public static void renderIO(@Nonnull IConduitBundle bundle, @Nonnull IClientConduit conduit, @Nonnull CollidableComponent component, BlockRenderLayer layer, @Nonnull List<BakedQuad> quads, @Nonnull DyeColor inChannel, @Nonnull DyeColor outChannel) {
        if (layer != BlockRenderLayer.CUTOUT || !component.isDirectional()) {
            return;
        }
        EnumFacing dir = component.getDirection();
        if (!conduit.getExternalConnections().contains(dir)) {
            return;
        }
        ConnectionMode mode = conduit.getConnectionMode(dir);
        if (!mode.acceptsInput() && !mode.acceptsOutput()) {
            return;
        }
        ConduitInOutRenderer.addColorBand(conduit, component, quads, dir, mode);
        if (conduit instanceof IRedstoneConduit) {
            if (mode == ConnectionMode.INPUT) {
                mode = ConnectionMode.OUTPUT;
            } else if (mode == ConnectionMode.OUTPUT) {
                mode = ConnectionMode.INPUT;
            }
        }
        Offset offset = bundle.getOffset(conduit.getBaseConduitType(), dir);
        ConduitGeometryUtil geometry = ConduitGeometryUtil.getInstance();
        geometry.addModeConnectorQuads(dir, offset, ICON_BG.get(TextureAtlasSprite.class), null, quads);
        if (mode.acceptsInput()) {
            if (mode.acceptsOutput()) {
                geometry.addModeConnectorQuads(dir, offset, ICON_INOUT_IN.get(TextureAtlasSprite.class), ColorUtil.toFloat4((int)inChannel.getColor()), quads);
                geometry.addModeConnectorQuads(dir, offset, ICON_INOUT_OUT.get(TextureAtlasSprite.class), ColorUtil.toFloat4((int)outChannel.getColor()), quads);
            } else {
                geometry.addModeConnectorQuads(dir, offset, ICON_IN.get(TextureAtlasSprite.class), ColorUtil.toFloat4((int)inChannel.getColor()), quads);
            }
        } else if (mode.acceptsOutput()) {
            geometry.addModeConnectorQuads(dir, offset, ICON_OUT.get(TextureAtlasSprite.class), ColorUtil.toFloat4((int)outChannel.getColor()), quads);
        }
    }

    private static void addColorBand(@Nonnull IClientConduit conduit, @Nonnull CollidableComponent component, @Nonnull List<BakedQuad> quads, @Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        IExtractor pc;
        RedstoneControlMode extractionRedstoneMode;
        if ("ColorController".equals(component.data) && conduit instanceof IExtractor && (extractionRedstoneMode = (pc = (IExtractor)((Object)conduit)).getExtractionRedstoneMode(dir)) != RedstoneControlMode.IGNORE && extractionRedstoneMode != RedstoneControlMode.NEVER && mode.acceptsInput()) {
            int cInt = pc.getExtractionSignalColor(dir).getColor();
            BoundingBox bound = component.bound;
            if (mode != ConnectionMode.NOT_SET) {
                Vector3d trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)-0.12);
                bound = trans != null ? bound.translate(trans) : bound;
            }
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (face == null || face == dir) continue;
                BakedQuadBuilder.addBakedQuadForFace(quads, bound, (TextureAtlasSprite)ModelLoader.White.INSTANCE, face, ConduitTexture.FULL, false, false, ColorUtil.toFloat4((int)cInt));
            }
        }
    }
}

