/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.property;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NNMap;
import crazypants.enderio.base.render.property.PropertyIO;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;

public class IOMode
implements Comparable<IOMode> {
    @Nonnull
    private final EnumFacing direction;
    @Nonnull
    private final EnumIOMode iomode;
    @Nonnull
    private static final NNMap<String, IOMode> VALUES = new NNMap.Brutal();
    public static final NNList<IOMode> MODES = new NNList();
    @Nonnull
    public static final PropertyIO IO = PropertyIO.getInstance();

    @Nonnull
    public static IOMode get(@Nonnull EnumFacing direction, @Nonnull EnumIOMode iomode) {
        String key = direction.toString().toLowerCase(Locale.US) + "_" + iomode.toString().toLowerCase(Locale.US);
        if (!VALUES.containsKey((Object)key)) {
            IOMode result = new IOMode(direction, iomode);
            VALUES.put((Object)key, (Object)result);
        }
        return (IOMode)VALUES.get((Object)key);
    }

    private IOMode(@Nonnull EnumFacing direction, @Nonnull EnumIOMode iomode) {
        this.direction = direction;
        this.iomode = iomode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.iomode.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IOMode other = (IOMode)obj;
        if (this.direction != other.direction) {
            return false;
        }
        return this.iomode == other.iomode;
    }

    @Override
    public int compareTo(IOMode o) {
        int d = this.direction.compareTo((Enum)o.direction);
        if (d != 0) {
            return d;
        }
        return this.iomode.ordinal() < o.iomode.ordinal() ? -1 : (this.iomode.ordinal() > o.iomode.ordinal() ? 1 : 0);
    }

    @Nonnull
    public String toString() {
        return this.direction.toString().toLowerCase(Locale.US) + "_" + this.iomode.toString().toLowerCase(Locale.US);
    }

    @Nonnull
    public EnumFacing getDirection() {
        return this.direction;
    }

    @Nonnull
    public EnumIOMode getIomode() {
        return this.iomode;
    }

    static {
        for (EnumFacing facing : NNList.FACING) {
            NNList.NNIterator iomodes = EnumIOMode.IOMODES.iterator();
            while (iomodes.hasNext()) {
                MODES.add((Object)IOMode.get(facing, (EnumIOMode)((Object)iomodes.next())));
            }
        }
    }

    public static enum EnumIOMode {
        NONE,
        DISABLED,
        DISABLEDNOCENTER,
        DISABLEDSIDES,
        PULL,
        PULLSIDES,
        PULLTOPBOTTOM,
        PUSH,
        PUSHPULL,
        PUSHPULLSIDES,
        PUSHPULLTOPBOTTOM,
        PUSHSIDES,
        PUSHTOPBOTTOM,
        SELECTEDFACE,
        TRANSCIEVERDISABLED,
        TRANSCIEVERPULL,
        TRANSCIEVERPUSH,
        TRANSCIEVERPUSHPULL,
        CAPACITORBANK,
        CAPACITORBANKINPUT,
        CAPACITORBANKLOCKED,
        CAPACITORBANKOUTPUT,
        CAPACITORBANKINPUTSMALL,
        CAPACITORBANKLOCKEDSMALL,
        CAPACITORBANKOUTPUTSMALL,
        RESERVOIR;

        public static final NNList<EnumIOMode> IOMODES;

        static {
            IOMODES = NNList.of(EnumIOMode.class);
        }
    }
}

