/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render;

import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.property.IOMode;
import crazypants.enderio.base.render.util.ItemQuadCollector;
import crazypants.enderio.base.render.util.QuadCollector;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public interface IRenderMapper {

    public static interface IItemRenderMapper
    extends IRenderMapper {
        @SideOnly(value=Side.CLIENT)
        @Nonnull
        default public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
            return cacheKey;
        }

        public static interface IDynamicOverlayMapper
        extends IItemRenderMapper {
            @SideOnly(value=Side.CLIENT)
            @Nullable
            public ItemQuadCollector mapItemDynamicOverlayRender(@Nonnull Block var1, @Nonnull ItemStack var2);
        }

        public static interface IItemModelMapper
        extends IItemRenderMapper {
            @SideOnly(value=Side.CLIENT)
            @Nullable
            public List<IBakedModel> mapItemRender(@Nonnull Block var1, @Nonnull ItemStack var2);
        }

        public static interface IItemStateMapper
        extends IItemRenderMapper {
            @SideOnly(value=Side.CLIENT)
            @Nullable
            public List<Pair<IBlockState, ItemStack>> mapItemRender(@Nonnull Block var1, @Nonnull ItemStack var2, @Nonnull ItemQuadCollector var3);
        }
    }

    public static interface IBlockRenderMapper
    extends IRenderMapper {
        @SideOnly(value=Side.CLIENT)
        @Nullable
        public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper var1, @Nonnull IBlockAccess var2, @Nonnull BlockPos var3, BlockRenderLayer var4, @Nonnull QuadCollector var5);

        @SideOnly(value=Side.CLIENT)
        @Nullable
        default public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, boolean isPainted) {
            return null;
        }

        public static interface IRenderLayerAware
        extends IBlockRenderMapper {

            public static interface IPaintAware
            extends IRenderLayerAware {
            }
        }
    }
}

