/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.paint;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.paint.PaintSourceParser;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.RecipeInput;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.item.ItemStack;

public class PaintSourceValidator {
    public static final PaintSourceValidator instance = new PaintSourceValidator();
    private final List<RecipeInput> whitelist = new ArrayList<RecipeInput>();
    private final List<RecipeInput> blacklist = new ArrayList<RecipeInput>();

    public boolean isValidSourceDefault(@Nonnull ItemStack paintSource) {
        if (Prep.isInvalid(paintSource)) {
            return false;
        }
        Block block = PaintUtil.getBlockFromItem(paintSource);
        if (block == null) {
            return false;
        }
        if (this.isBlacklisted(paintSource)) {
            return false;
        }
        if (this.isWhitelisted(paintSource)) {
            return true;
        }
        return (Boolean)RecipeConfig.allowTileEntitiesAsPaintSource.get() != false || !(block instanceof ITileEntityProvider);
    }

    public boolean isWhitelisted(@Nonnull ItemStack paintSource) {
        return this.isInList(paintSource, this.whitelist);
    }

    public boolean isBlacklisted(@Nonnull ItemStack paintSource) {
        return this.isInList(paintSource, this.blacklist);
    }

    public void addToWhitelist(@Nonnull ItemStack input) {
        this.addToWhitelist(new RecipeInput(input, true));
    }

    public void addToWhitelist(RecipeInput input) {
        this.whitelist.add(input);
    }

    public void addToBlacklist(@Nonnull ItemStack input) {
        this.addToBlacklist(new RecipeInput(input, true));
    }

    public void addToBlacklist(RecipeInput input) {
        this.blacklist.add(input);
    }

    public void removeFromWhitelist(IRecipeInput input) {
        this.removeFromList(input, this.whitelist);
    }

    public void removeFromBlackList(IRecipeInput input) {
        this.removeFromList(input, this.blacklist);
    }

    protected boolean isInList(@Nonnull ItemStack paintSource, List<RecipeInput> list) {
        if (Prep.isInvalid(paintSource)) {
            return false;
        }
        for (IRecipeInput iRecipeInput : list) {
            if (iRecipeInput == null || !iRecipeInput.isInput(paintSource)) continue;
            return true;
        }
        return false;
    }

    protected void removeFromList(IRecipeInput input, List<RecipeInput> list) {
        ItemStack inStack = input.getInput();
        if (Prep.isInvalid(inStack)) {
            return;
        }
        IRecipeInput toRemove = null;
        for (IRecipeInput iRecipeInput : list) {
            if (!ItemUtil.areStacksEqual((ItemStack)inStack, (ItemStack)iRecipeInput.getInput())) continue;
            toRemove = iRecipeInput;
            break;
        }
        if (toRemove != null) {
            list.remove(toRemove);
        }
    }

    public void loadConfig() {
        PaintSourceParser.loadConfig();
    }
}

