/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.modes;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import javax.annotation.Nonnull;

public enum IoMode {
    NONE("gui.machine.ioMode.none"),
    PULL("gui.machine.ioMode.pull"),
    PUSH("gui.machine.ioMode.push"),
    PUSH_PULL("gui.machine.ioMode.pullPush"),
    DISABLED("gui.machine.ioMode.disabled");

    @Nonnull
    private final String unlocalisedName;

    private IoMode(String unlocalisedName) {
        this.unlocalisedName = unlocalisedName;
    }

    @Nonnull
    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public boolean pulls() {
        return this == PULL || this == PUSH_PULL;
    }

    public boolean pushes() {
        return this == PUSH || this == PUSH_PULL;
    }

    public boolean canOutput() {
        return this.pushes() || this == NONE;
    }

    public boolean canRecieveInput() {
        return this.pulls() || this == NONE;
    }

    public boolean canInputOrOutput() {
        return this != DISABLED;
    }

    @Nonnull
    public String getLocalisedName() {
        return EnderIO.lang.localize(this.unlocalisedName);
    }

    @Nonnull
    public String colorLocalisedName() {
        return EnderIO.lang.localize(this.getColorerUnlocalizedName());
    }

    @Nonnull
    public String getColorerUnlocalizedName() {
        return this.getUnlocalisedName() + ".colored";
    }

    @Nonnull
    public IoMode next() {
        return (IoMode)((Object)NNList.of(IoMode.class).next((Object)this));
    }

    @Nonnull
    public IoMode prev() {
        return (IoMode)((Object)NNList.of(IoMode.class).prev((Object)this));
    }
}

