/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.network;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPowerStorage
extends MessageTileEntity<AbstractCapabilityMachineEntity> {
    private int storedEnergy;

    public PacketPowerStorage() {
    }

    public PacketPowerStorage(@Nonnull AbstractCapabilityMachineEntity ent) {
        super((TileEntity)ent);
        this.storedEnergy = ent.getEnergy().getEnergyStored();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.storedEnergy);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.storedEnergy = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketPowerStorage, IMessage> {
        public IMessage onMessage(PacketPowerStorage message, MessageContext ctx) {
            AbstractCapabilityMachineEntity te = (AbstractCapabilityMachineEntity)message.getTileEntity(message.getWorld(ctx));
            if (te != null) {
                te.getEnergy().setEnergyStored(message.storedEnergy);
            }
            return null;
        }
    }
}

