/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.lang;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public interface ILang {
    @Nonnull
    public String getKey();

    @Nonnull
    public Lang getLang();

    @Nonnull
    default public String get() {
        return this.getLang().localizeExact(this.getKey());
    }

    @Nonnull
    default public String get(Object ... params) {
        return this.getLang().localizeExact(this.getKey(), params);
    }

    @Nonnull
    default public TextComponentString toChat() {
        return new TextComponentString(this.getLang().localizeExact(this.getKey()));
    }

    @Nonnull
    default public TextComponentString toChat(Object ... params) {
        return new TextComponentString(this.getLang().localizeExact(this.getKey(), params));
    }

    @Nonnull
    default public TextComponentTranslation toChatServer() {
        return new TextComponentTranslation(this.getKey(), new Object[0]);
    }

    @Nonnull
    default public TextComponentTranslation toChatServer(Object ... params) {
        return new TextComponentTranslation(this.getKey(), params);
    }

    @Nonnull
    default public NNList<String> getLines(Object ... params) {
        NNList result = new NNList();
        for (int i = 1; i < 12; ++i) {
            String linekey = this.getKey() + ".line" + i;
            if (!this.getLang().canLocalizeExact(linekey)) {
                return result;
            }
            result.add((Object)this.getLang().localizeExact(linekey, params));
        }
        return result;
    }

    default public void checkTranslation() {
        if (!this.getLang().canLocalizeExact(this.getKey()) && !this.getLang().canLocalizeExact(this.getKey() + ".line1")) {
            Log.error("Missing translation for '" + this + "': " + this.get());
        }
    }
}

