/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.handler.darksteel.PacketUpgradeState;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.network.PacketHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="enderio")
public class StateController {
    @Nonnull
    private static final String ENDERIO_FLAGS = "enderio:flags";

    private static NBTTagCompound getActiveSetNBT(@Nonnull EntityPlayer player) {
        NBTTagCompound entityData = player.getEntityData();
        if (entityData.func_150297_b(ENDERIO_FLAGS, 10)) {
            return entityData.func_74775_l(ENDERIO_FLAGS);
        }
        NBTTagCompound set = new NBTTagCompound();
        entityData.func_74782_a(ENDERIO_FLAGS, (NBTBase)set);
        return set;
    }

    @SubscribeEvent
    public static void onTracking(PlayerEvent.StartTracking event) {
        Entity target;
        EntityPlayer toUpdate = event.getEntityPlayer();
        if (toUpdate instanceof EntityPlayerMP && (target = event.getTarget()) instanceof EntityPlayer) {
            StateController.updateFlags((EntityPlayerMP)toUpdate, (EntityPlayer)target);
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            StateController.updateFlags((EntityPlayerMP)player, player);
        }
    }

    private static void updateFlags(@Nonnull EntityPlayerMP toUpdate, @Nonnull EntityPlayer target) {
        NBTTagCompound activeSet = StateController.getActiveSetNBT(target);
        PacketUpgradeState packet = new PacketUpgradeState(target.func_145782_y());
        UpgradeRegistry.getUpgrades().apply(type -> {
            if (activeSet.func_74764_b(type.getKeybindingID())) {
                packet.add(type.getKeybindingID(), activeSet.func_74767_n(type.getKeybindingID()));
            }
        });
        PacketHandler.sendTo(packet, toUpdate);
    }

    public static boolean isActive(@Nonnull EntityPlayer player, @Nullable IDarkSteelUpgrade type) {
        NBTTagCompound activeSet = StateController.getActiveSetNBT(player);
        return type != null && (activeSet.func_74764_b(type.getKeybindingID()) ? activeSet.func_74767_n(type.getKeybindingID()) : type.keybindingDefault());
    }

    public static void setActive(@Nonnull EntityPlayer player, @Nonnull IDarkSteelUpgrade type, boolean isActive) {
        StateController.setActive(player, type.getKeybindingID(), isActive);
    }

    public static void setActive(@Nonnull EntityPlayer player, @Nonnull String type, boolean isActive) {
        if (player.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(type, isActive));
        } else {
            StateController.syncActive(player, type, isActive);
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketUpgradeState(type, isActive, player.func_145782_y()), player.field_70170_p.field_73011_w.getDimension());
        }
    }

    public static void syncActive(@Nonnull EntityPlayer player, @Nonnull String type, boolean isActive) {
        StateController.getActiveSetNBT(player).func_74757_a(type, isActive);
    }
}

