/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.IRecipeRoot;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StaxFactory {
    private final XMLEventReader eventReader;
    private final String source;

    public StaxFactory(XMLEventReader eventReader, String source) {
        this.eventReader = eventReader;
        this.source = source;
    }

    public <T extends IRecipeRoot> T readRoot(T target, String rootElement) throws XMLStreamException, InvalidRecipeConfigException {
        T result = null;
        block4: while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            switch (event.getEventType()) {
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 11: 
                case 13: {
                    continue block4;
                }
                case 1: {
                    if (result != null) break;
                    StartElement startElement = event.asStartElement();
                    if (rootElement.equals(startElement.getName().getLocalPart())) {
                        result = this.read(target, startElement);
                        continue block4;
                    }
                    throw new InvalidRecipeConfigException("Unexpected tag '" + startElement.getName() + "'");
                }
            }
            throw new InvalidRecipeConfigException("Unexpected element '" + event + "'");
        }
        if (result == null) {
            throw new InvalidRecipeConfigException("Missing top-level tag '" + rootElement + "'");
        }
        return result;
    }

    @Nonnull
    public <T extends IRecipeConfigElement> T read(T target, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        target.setSource(this.source != null ? this.source : "unkown");
        try {
            Iterator<Attribute> attributes = startElement.getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                if (target.setAttribute(this, attribute.getName().getLocalPart().toString(), (String)NullHelper.first((Object[])new String[]{attribute.getValue(), ""}))) continue;
                throw new InvalidRecipeConfigException("Unexpected attribute '" + attribute.getName() + "' inside " + startElement.getName());
            }
        }
        catch (InvalidRecipeConfigException e) {
            if (e.getMessage().contains("[row,col]")) {
                throw e;
            }
            throw new InvalidRecipeConfigException(e, "at [row,col]:[" + startElement.getLocation().getLineNumber() + "," + startElement.getLocation().getColumnNumber() + "]");
        }
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            try {
                if (event.isStartElement()) {
                    if (target.setElement(this, (String)NullHelper.first((Object[])new String[]{event.asStartElement().getName().getLocalPart(), ""}), (StartElement)NullHelper.first((Object)event.asStartElement(), (Supplier[])new Supplier[0]))) continue;
                    throw new InvalidRecipeConfigException("Unexpected tag '" + event.asStartElement().getName() + "' inside " + startElement.getName());
                }
                if (event.isEndElement()) {
                    target.readResolve();
                    return target;
                }
                if (event.isCharacters() && event.asCharacters().isWhiteSpace() || event.getEventType() == 5) continue;
                throw new InvalidRecipeConfigException("Unexpected '" + event.getEventType() + "' inside " + startElement.getName());
            }
            catch (InvalidRecipeConfigException e) {
                if (e.getMessage().contains("[row,col]")) {
                    throw e;
                }
                throw new InvalidRecipeConfigException(e, "at [row,col]:[" + event.getLocation().getLineNumber() + "," + event.getLocation().getColumnNumber() + "]");
            }
        }
        throw new InvalidRecipeConfigException("Unexpected end of document inside " + startElement.getName());
    }

    public void skip(StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(startElement.getName().getLocalPart())) continue;
            return;
        }
        throw new InvalidRecipeConfigException("Unexpected end of document inside " + startElement.getName());
    }
}

