/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.registry;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.conduit.registry.ConduitDefinition;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ConduitTypeDefinition {
    @Nonnull
    private final UUID networkUUID;
    @Nonnull
    private final NNList<UUID> aliases = new NNList();
    @Nonnull
    private final Class<? extends IConduit> baseType;
    @Nonnull
    private final Offset none;
    @Nonnull
    private final Offset x;
    @Nonnull
    private final Offset y;
    @Nonnull
    private final Offset z;
    private final boolean canConnectToAnything;
    @Nonnull
    private final NNList<ConduitDefinition> members = new NNList();

    public ConduitTypeDefinition(@Nonnull UUID networkUUID, @Nonnull Class<? extends IConduit> baseType, @Nonnull Offset none, @Nonnull Offset x, @Nonnull Offset y, @Nonnull Offset z, boolean canConnectToAnything) {
        this.networkUUID = networkUUID;
        this.baseType = baseType;
        this.none = none;
        this.x = x;
        this.y = y;
        this.z = z;
        this.canConnectToAnything = canConnectToAnything;
        this.aliases.add((Object)UUID.nameUUIDFromBytes(baseType.getName().getBytes()));
    }

    public ConduitTypeDefinition(@Nonnull UUID networkUUID, @Nonnull Class<? extends IConduit> baseType, @Nonnull Offset none, @Nonnull Offset x, @Nonnull Offset y, @Nonnull Offset z) {
        this(networkUUID, baseType, none, x, y, z, false);
    }

    public ConduitTypeDefinition(@Nonnull UUID networkUUID, @Nonnull Class<? extends IConduit> baseType, boolean canConnectToAnything) {
        this(networkUUID, baseType, Offset.NONE, Offset.NONE, Offset.NONE, Offset.NONE, canConnectToAnything);
    }

    public ConduitTypeDefinition(@Nonnull UUID networkUUID, @Nonnull Class<? extends IConduit> baseType) {
        this(networkUUID, baseType, Offset.NONE, Offset.NONE, Offset.NONE, Offset.NONE, false);
    }

    void addMember(@Nonnull ConduitDefinition member) {
        this.members.add((Object)member);
    }

    @Nonnull
    public NNList<ConduitDefinition> getMembers() {
        return this.members;
    }

    @Nonnull
    public UUID getUUID() {
        return this.networkUUID;
    }

    @Nonnull
    public NNList<UUID> getAliases() {
        return this.aliases;
    }

    @Nonnull
    public Class<? extends IConduit> getBaseType() {
        return this.baseType;
    }

    @Nonnull
    public Offset getPreferedOffsetForNone() {
        return this.none;
    }

    @Nonnull
    public Offset getPreferedOffsetForX() {
        return this.x;
    }

    @Nonnull
    public Offset getPreferedOffsetForY() {
        return this.y;
    }

    @Nonnull
    public Offset getPreferedOffsetForZ() {
        return this.z;
    }

    public boolean canConnectToAnything() {
        return this.canConnectToAnything;
    }

    public int hashCode() {
        return this.networkUUID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConduitTypeDefinition other = (ConduitTypeDefinition)obj;
        return this.networkUUID.equals(other.networkUUID);
    }
}

