/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.holy;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.render.IDefaultRenderers;
import crazypants.enderio.base.render.ranged.InfinityParticle;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockHolyFog
extends BlockEio<TileEntityEio>
implements IDefaultRenderers,
IResourceTooltipProvider {
    @Nonnull
    public static final PropertyInteger GEN = PropertyInteger.func_177719_a((String)"amount", (int)0, (int)15);

    public static BlockHolyFog create(@Nonnull IModObject modObject) {
        BlockHolyFog result = new BlockHolyFog(modObject, false);
        return result;
    }

    protected BlockHolyFog(@Nonnull IModObject modObject, boolean silent) {
        super(modObject, (Material)new MaterialTransparent(MapColor.field_151660_b));
        this.func_149647_a(EnderIOTab.tabEnderIOMaterials);
        this.func_149672_a(new SoundType(-1.0f, 1.0f, SoundEvents.field_187546_ae, SoundEvents.field_187554_ai, SoundEvents.field_187552_ah, SoundEvents.field_187550_ag, SoundEvents.field_187548_af));
        this.initDefaultState();
        this.setShape(this.mkShape(BlockFaceShape.UNDEFINED));
        this.func_149715_a(1.0f);
    }

    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)GEN, (Comparable)Integer.valueOf(15)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GEN});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)GEN, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)GEN);
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockStateIn, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_176209_a(@Nonnull IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
    }

    public boolean func_176200_f(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean isAir(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public void onBlockPlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull ItemStack stack) {
        if (!world.field_72995_K) {
            world.func_180497_b(pos, (Block)this, 5, 0);
        } else {
            for (int i = 0; i < 5; ++i) {
                BlockHolyFog.makeParticle(world, pos, world.field_73012_v);
            }
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (!world.field_72995_K) {
            world.func_180497_b(pos, (Block)this, 5, 0);
        }
    }

    private int getQuanta(IBlockState state) {
        return state == null || !(state.func_177230_c() instanceof BlockHolyFog) ? 0 : (Integer)state.func_177229_b((IProperty)GEN) + 1;
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rnd) {
        if (!world.field_72995_K) {
            Pair next2;
            NNList.NNIterator itr;
            IBlockState down = world.func_180495_p(pos.func_177977_b());
            if (down.func_177230_c() == Blocks.field_150350_a) {
                world.func_175698_g(pos);
                world.func_175656_a(pos.func_177977_b(), state);
                world.func_180497_b(pos.func_177977_b(), (Block)this, 5, 0);
                return;
            }
            int downQuanta = this.getQuanta(down);
            if (downQuanta > 0 && downQuanta < 16) {
                if ((downQuanta += this.getQuanta(state)) <= 16) {
                    world.func_175698_g(pos);
                    world.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)GEN, (Comparable)Integer.valueOf(downQuanta - 1)));
                    world.func_180497_b(pos.func_177977_b(), (Block)this, 5, 0);
                } else {
                    int myQuanta = downQuanta - 16;
                    downQuanta = 16;
                    world.func_175656_a(pos, state.func_177226_a((IProperty)GEN, (Comparable)Integer.valueOf(myQuanta - 1)));
                    world.func_180497_b(pos, (Block)this, 6, 0);
                    world.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)GEN, (Comparable)Integer.valueOf(downQuanta - 1)));
                    world.func_180497_b(pos.func_177977_b(), (Block)this, 5, 0);
                }
                return;
            }
            int totalQuanta = this.getQuanta(state);
            NNList list = new NNList();
            NNList.NNIterator itr2 = NNList.FACING_HORIZONTAL.fastIterator();
            while (itr2.hasNext()) {
                EnumFacing facing = (EnumFacing)itr2.next();
                IBlockState neighbor = world.func_180495_p(pos.func_177972_a(facing));
                if (neighbor.func_177230_c() == Blocks.field_150350_a) {
                    list.add((Object)Pair.of((Object)pos.func_177972_a(facing), (Object)neighbor));
                    continue;
                }
                if (!(neighbor.func_177230_c() instanceof BlockHolyFog)) continue;
                totalQuanta += this.getQuanta(neighbor);
                list.add((Object)Pair.of((Object)pos.func_177972_a(facing), (Object)neighbor));
            }
            if (list.isEmpty()) {
                return;
            }
            list.add(0, (Object)Pair.of((Object)pos, (Object)state));
            int quantaPerBlock = totalQuanta / list.size();
            int extraQuanta = totalQuanta - quantaPerBlock * list.size();
            if (quantaPerBlock == 0) {
                itr = list.iterator();
                while (itr.hasNext()) {
                    next2 = (Pair)itr.next();
                    if (((IBlockState)next2.getValue()).func_177230_c() != Blocks.field_150350_a) continue;
                    itr.remove();
                    quantaPerBlock = totalQuanta / list.size();
                    extraQuanta = totalQuanta - quantaPerBlock * list.size();
                    if (quantaPerBlock <= 0) continue;
                    break;
                }
            }
            if (extraQuanta > 0) {
                itr = list.iterator();
                while (itr.hasNext()) {
                    next2 = (Pair)itr.next();
                    if (this.getQuanta((IBlockState)next2.getValue()) != quantaPerBlock + 1) continue;
                    itr.remove();
                    if (--extraQuanta != 0) continue;
                    break;
                }
            }
            for (Pair next2 : list) {
                int q = quantaPerBlock;
                if (extraQuanta > 0) {
                    ++q;
                    --extraQuanta;
                }
                BlockPos target = (BlockPos)next2.getKey();
                if (this.getQuanta((IBlockState)next2.getValue()) == q) continue;
                if (q < 1) {
                    world.func_175698_g(target);
                    continue;
                }
                world.func_175656_a(target, state.func_177226_a((IProperty)GEN, (Comparable)Integer.valueOf(q - 1)));
                world.func_180497_b(target, (Block)this, 5, 0);
            }
        }
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.UNDEAD && RANDOM.nextFloat() < 0.05f) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rnd) {
        int quanta = this.getQuanta(bs);
        float f = rnd.nextFloat();
        float f2 = quanta == 16 ? 1.0f : (quanta > 10 ? 0.01f : 0.001f);
        if (f < f2 * (float)quanta) {
            BlockHolyFog.makeParticle(world, pos, rnd);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static void makeParticle(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rnd) {
        float offsetX = 0.25f + 0.5f * rnd.nextFloat();
        float offsetY = 0.25f + 0.5f * rnd.nextFloat();
        float offsetZ = 0.25f + 0.5f * rnd.nextFloat();
        float maxSize = Math.min(Math.min(Math.min(1.0f - offsetX, offsetX), Math.min(1.0f - offsetY, offsetY)), Math.min(1.0f - offsetZ, offsetZ)) * (0.5f + 0.5f * rnd.nextFloat()) / 4.0f;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new InfinityParticle(world, pos, new Vector4f(0.99215686f, 1.0f, 0.0f, 0.4f), new Vector4f(offsetX, offsetY, offsetZ, maxSize)));
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_149739_a();
    }
}

