/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.charge;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.block.charge.ChargeRegister;
import crazypants.enderio.base.block.charge.EntityPrimedCharge;
import crazypants.enderio.base.block.charge.ICharge;
import crazypants.enderio.base.block.charge.PacketExplodeEffect;
import crazypants.enderio.base.config.config.BlockConfig;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.render.IDefaultRenderers;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleSpell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockConfusionCharge
extends BlockTNT
implements ICharge,
IDefaultRenderers,
IModObject.WithBlockItem {
    private int chargeId;

    public static BlockConfusionCharge create(@Nonnull IModObject modObject) {
        return new BlockConfusionCharge(modObject);
    }

    public BlockConfusionCharge(@Nonnull IModObject modObject) {
        this.func_149647_a(EnderIOTab.tabEnderIO);
        modObject.apply(this);
        ChargeRegister.instance.registerCharge(this);
    }

    @Override
    public int getID() {
        return this.chargeId;
    }

    @Override
    public void setID(int id) {
        this.chargeId = id;
    }

    @Override
    @Nonnull
    public Block getBlock() {
        return this;
    }

    @Override
    public void explode(@Nonnull EntityPrimedCharge entity) {
        World world = entity.func_130014_f_();
        world.func_184148_a((EntityPlayer)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 3.0f, 1.4f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketExplodeEffect((Entity)entity, this), new BlockPos((Entity)entity), entity.field_70170_p);
    }

    public void func_180692_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase igniter) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176246_a)).booleanValue()) {
            EntityPrimedCharge entity = new EntityPrimedCharge(this, world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, igniter);
            world.func_72838_d((Entity)entity);
            world.func_184148_a((EntityPlayer)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_72870_g((Entity)entity);
        }
    }

    @Nonnull
    protected static AxisAlignedBB getBoundsAround(double x, double y, double z, double range) {
        return new AxisAlignedBB(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void explodeEffect(@Nonnull World world, double x, double y, double z) {
        List players = world.func_72872_a(EntityPlayer.class, BlockConfusionCharge.getBoundsAround(x, y, z, ((Float)BlockConfig.confusingChargeRange.get()).floatValue()));
        double maxDistanceSq = ((Float)BlockConfig.confusingChargeRange.get()).floatValue() * ((Float)BlockConfig.confusingChargeRange.get()).floatValue();
        for (EntityPlayer player : players) {
            double playerDistSq = player.func_70092_e(x, y, z);
            if (!(playerDistSq < maxDistanceSq)) continue;
            double scale = 1.0 - playerDistSq / maxDistanceSq;
            scale = Math.exp(scale) / Math.E;
            int duration = (int)Math.ceil((double)((Integer)BlockConfig.confusingChargeEffectDuration.get()).intValue() * scale);
            player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration, 1, false, true));
        }
        world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, x, y, z, 1.0, 0.0, 0.0, new int[0]);
        int col = MobEffects.field_76431_k.func_76401_j();
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col >> 0 & 0xFF) / 255.0f;
        Random random = world.field_73012_v;
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble() * 2.0;
            double mag = 25.0;
            double motionX = (0.5 - random.nextDouble()) * mag * d;
            double motionY = (0.5 - random.nextDouble()) * mag;
            double motionZ = (0.5 - random.nextDouble()) * mag * d;
            ParticleSpell entityfx = (ParticleSpell)new ParticleSpell.InstantFactory().func_178902_a(i, world, x + motionX * 0.1, y + motionY * 0.1, z + motionZ * 0.1, motionX, motionY, motionZ, new int[0]);
            float colRan = 0.75f + random.nextFloat() * 0.25f;
            entityfx.func_70538_b(r * colRan, g * colRan, b * colRan);
            entityfx.func_70543_e(0.1f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)entityfx);
        }
    }

    public void func_180652_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
        if (!world.field_72995_K) {
            EntityLivingBase placedBy = explosion.func_94613_c();
            this.onIgnitedByNeighbour(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), placedBy);
        }
    }

    protected void onIgnitedByNeighbour(World world, int x, int y, int z, EntityLivingBase placedBy) {
        EntityPrimedCharge entity = new EntityPrimedCharge(this, world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, placedBy);
        entity.func_184534_a(world.field_73012_v.nextInt(entity.func_184536_l() / 4) + entity.func_184536_l() / 8);
        world.func_72838_d((Entity)entity);
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }
}

