/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base;

import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="enderio")
public final class Log {
    private static boolean inDev = System.getProperty("INDEV") != null;
    public static final Logger LOGGER = LogManager.getLogger((String)"enderio");

    public static void warn(Object ... msg) {
        LOGGER.warn(() -> Log.join(msg));
    }

    public static void error(Object ... msg) {
        LOGGER.error(() -> Log.join(msg));
    }

    public static void info(Object ... msg) {
        LOGGER.info(() -> Log.join(msg));
    }

    public static void debug(Object ... msg) {
        if (inDev) {
            LOGGER.info(() -> "INDEV: " + Log.join(msg));
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(() -> Log.join(msg));
        }
    }

    public static void livetraceNBT(Object ... msg) {
        if (((Boolean)DiagnosticsConfig.debugTraceNBTActivityExtremelyDetailed.get()).booleanValue()) {
            LOGGER.info(Log.join("", msg));
        }
    }

    public static String join(CharSequence delimiter, Object ... elements) {
        StringBuilder joiner = new StringBuilder();
        for (Object cs : elements) {
            if (joiner.length() != 0) {
                joiner.append(delimiter);
            }
            joiner.append(cs);
        }
        return joiner.toString();
    }

    public static String join(Object ... elements) {
        StringBuilder joiner = new StringBuilder();
        for (Object cs : elements) {
            joiner.append(cs);
        }
        return joiner.toString();
    }

    private Log() {
    }

    @SubscribeEvent
    public static void preInit(EnderIOLifecycleEvent.Config.Pre event) {
        if (LOGGER.isDebugEnabled()) {
            Log.warn("========================================================");
            Log.warn("== Debug Logging is ENABLED ============================");
            Log.warn("======================================================== ");
            Log.warn("== This WILL slow down the game, so we recommend you  ==");
            Log.warn("== disable it unless you need it. A log level of INFO ==");
            Log.warn("== is enough for normal operation.                    ==");
            Log.warn("========================================================  ");
        }
    }

    @SubscribeEvent
    public static void preInit2(EnderIOLifecycleEvent.Config.Post event) {
        inDev |= ((Boolean)DiagnosticsConfig.debugUpgradeDebugMessagesToInfo.get()).booleanValue();
    }

    public static boolean isInDev() {
        return inDev;
    }
}

