/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.energy.storage;

import icbm.classic.api.energy.IEnergyBuffer;
import icbm.classic.lib.energy.storage.EnergyActionType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyBuffer
implements IEnergyBuffer,
IEnergyStorage,
INBTSerializable {
    private int maxStorage;
    private int energyStorage;

    public EnergyBuffer(int maxStorage) {
        this.maxStorage = maxStorage;
    }

    @Override
    public int addEnergyToStorage(int energy, boolean doAction) {
        int prev = this.getEnergyStored();
        if (energy > 0) {
            int roomLeft = this.getMaxBufferSize() - this.getEnergyStored();
            if (energy < roomLeft) {
                if (doAction) {
                    this.energyStorage += energy;
                    if (prev != this.energyStorage) {
                        this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.ADD);
                    }
                }
                return energy;
            }
            if (doAction) {
                this.energyStorage = this.getMaxBufferSize();
                if (prev != this.energyStorage) {
                    this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.ADD);
                }
            }
            return roomLeft;
        }
        return 0;
    }

    @Override
    public int removeEnergyFromStorage(int energy, boolean doAction) {
        int prev = this.getEnergyStored();
        if (energy > 0 && this.getEnergyStored() > 0) {
            if (energy >= this.getEnergyStored()) {
                if (doAction) {
                    this.energyStorage = 0;
                    if (prev != this.getEnergyStored()) {
                        this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.REMOVE);
                    }
                }
                return this.getMaxBufferSize();
            }
            if (doAction) {
                this.energyStorage -= energy;
                if (prev != this.getEnergyStored()) {
                    this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.REMOVE);
                }
            }
            return energy;
        }
        return 0;
    }

    protected void onPowerChange(int prevEnergy, int current, EnergyActionType actionType) {
    }

    @Override
    public int getMaxBufferSize() {
        return this.maxStorage;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.addEnergyToStorage(maxReceive, !simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.removeEnergyFromStorage(maxExtract, !simulate);
    }

    @Override
    public int getEnergyStored() {
        return this.energyStorage;
    }

    public int getMaxEnergyStored() {
        return this.getMaxBufferSize();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public void setEnergyStored(int energy) {
        int prev = this.getEnergyStored();
        this.energyStorage = Math.min(this.getMaxBufferSize(), Math.max(0, energy));
        if (prev != this.energyStorage) {
            this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.SET);
        }
    }

    public NBTBase serializeNBT() {
        return new NBTTagInt(this.getEnergyStored());
    }

    public void deserializeNBT(NBTBase nbt) {
        if (nbt instanceof NBTPrimitive) {
            this.setEnergyStored(((NBTPrimitive)nbt).func_150287_d());
        }
    }
}

