/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.events.LaserRemoteTriggerEvent;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketPlayerItem;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.FakeRadioSender;
import icbm.classic.prefab.item.ItemICBMElectrical;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLaserDetonator
extends ItemICBMElectrical
implements IPacketIDReceiver {
    private final int maxCooldownTicks = 20;
    private int cooldownRemaining = 0;

    public ItemLaserDetonator() {
        super("laserDetonator");
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (world.field_72995_K && this.cooldownRemaining <= 0) {
            TileEntity tileEntity;
            this.cooldownRemaining = 20;
            RayTraceResult objectMouseOver = player.func_174822_a(200.0, 1.0f);
            if (objectMouseOver.field_72313_a != RayTraceResult.Type.MISS && !ICBMClassicHelpers.isLauncher(tileEntity = world.func_175625_s(objectMouseOver.func_178782_a()), null)) {
                ICBMClassic.packetHandler.sendToServer(new PacketPlayerItem(player).addData(new Object[]{objectMouseOver.func_178782_a()}));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (world.field_72995_K) {
            this.cooldownRemaining = 0;
        }
        return super.func_77654_b(stack, world, entityLiving);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K && this.cooldownRemaining > 0) {
            --this.cooldownRemaining;
        }
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket packet) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == this) {
            if (!player.field_70170_p.field_72995_K) {
                int z;
                int y;
                int x = buf.readInt();
                LaserRemoteTriggerEvent event = new LaserRemoteTriggerEvent(player.field_70170_p, new BlockPos(x, y = buf.readInt(), z = buf.readInt()), player);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                if (event.pos == null) {
                    RadioRegistry.popMessage(player.field_70170_p, new FakeRadioSender(player, stack, 2000), this.getBroadCastHz(stack), "activateLauncherWithTarget", new Pos(x, y, z));
                } else {
                    RadioRegistry.popMessage(player.field_70170_p, new FakeRadioSender(player, stack, 2000), this.getBroadCastHz(stack), "activateLauncherWithTarget", new Pos(event.pos.func_177958_n(), event.pos.func_177956_o(), event.pos.func_177952_p()));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Not encoded with launch data! Right click on launcher screen to encode."));
            }
        }
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean b) {
        list.add("Fires missiles remotely");
        list.add("Right click launcher screen to encode");
    }

    public float getBroadCastHz(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("hz")) {
            return stack.func_77978_p().func_74760_g("hz");
        }
        return 0.0f;
    }

    public void setBroadCastHz(ItemStack stack, float hz) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74776_a("hz", hz);
    }
}

