/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.radarstation;

import icbm.classic.ICBMClassic;
import icbm.classic.content.blocks.radarstation.ContainerRadarStation;
import icbm.classic.content.blocks.radarstation.RadarObjectType;
import icbm.classic.content.blocks.radarstation.TileRadarStation;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.transform.region.Rectangle;
import icbm.classic.lib.transform.vector.Point;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.gui.GuiContainerBase;
import java.io.IOException;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;

public class GuiRadarStation
extends GuiContainerBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("icbmclassic", "textures/gui/gui_radar.png");
    public static final ResourceLocation TEXTURE_RED_DOT = new ResourceLocation("icbmclassic", "textures/gui/reddot.png");
    public static final ResourceLocation TEXTURE_YELLOW_DOT = new ResourceLocation("icbmclassic", "textures/gui/yellowdot.png");
    public static final ResourceLocation TEXTURE_WHITE_DOT = new ResourceLocation("icbmclassic", "textures/gui/whitedot.png");
    private TileRadarStation tileEntity;
    private int containerPosX;
    private int containerPosY;
    private GuiTextField textFieldDetectionRange;
    private GuiTextField textFieldTriggerRange;
    private GuiTextField textFieldFrequency;
    private Point mouseOverCoords = new Point();
    private Point mousePosition = new Point();
    private Point radarCenter;
    private float radarMapRadius;
    private String info = "";
    private String info2;

    public GuiRadarStation(EntityPlayer player, TileRadarStation tileEntity) {
        super(new ContainerRadarStation(player, tileEntity));
        this.tileEntity = tileEntity;
        this.mouseOverCoords = new Point(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177952_p());
        this.field_147000_g = 166;
        this.field_146999_f = 256;
        this.radarCenter = new Point(this.containerPosX + this.field_146999_f / 3 - 14, this.containerPosY + this.field_147000_g / 2 + 4);
        this.radarMapRadius = 7.836991f;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.textFieldTriggerRange = new GuiTextField(0, this.field_146289_q, 210, 67, 30, 12);
        this.textFieldTriggerRange.func_146203_f(3);
        this.textFieldTriggerRange.func_146180_a(this.tileEntity.safetyRange + "");
        this.textFieldDetectionRange = new GuiTextField(1, this.field_146289_q, 210, 82, 30, 12);
        this.textFieldDetectionRange.func_146203_f(3);
        this.textFieldDetectionRange.func_146180_a(this.tileEntity.alarmRange + "");
        this.textFieldFrequency = new GuiTextField(2, this.field_146289_q, 210, 108, 30, 12);
        this.textFieldFrequency.func_146203_f(3);
        this.textFieldFrequency.func_146180_a(this.tileEntity.getFrequency() + "");
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String status;
        this.field_146289_q.func_78276_b("\u00a77" + LanguageUtility.getLocalName(BlockReg.blockRadarStation.func_149739_a()), this.field_146999_f / 2 - 30, 6, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.radar.coords"), 155, 18, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.misc.x") + " " + (int)Math.floor(this.mouseOverCoords.x()) + " " + LanguageUtility.getLocal("gui.misc.z") + " " + (int)Math.floor(this.mouseOverCoords.y()), 155, 30, 0x404040);
        this.field_146289_q.func_78276_b(this.info, 155, 42, 0x404040);
        this.field_146289_q.func_78276_b("\u00a74" + this.info2, 155, 54, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.radar.range"), 152, 55, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.radar.range.trigger"), 155, 70, 0x404040);
        this.textFieldTriggerRange.func_146194_f();
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.radar.range.detection"), 155, 85, 0x404040);
        this.textFieldDetectionRange.func_146194_f();
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.misc.freq"), 152, 110, 0x404040);
        this.textFieldFrequency.func_146194_f();
        String color = "\u00a74";
        if (this.tileEntity.hasPower()) {
            color = "\u00a72";
            status = LanguageUtility.getLocal("gui.radar.on");
        } else {
            status = LanguageUtility.getLocal("gui.radar.nopower");
        }
        this.field_146289_q.func_78276_b(color + status, 155, 150, 0x404040);
    }

    @Override
    public void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.textFieldTriggerRange.func_146201_a(par1, par2);
        this.textFieldDetectionRange.func_146201_a(par1, par2);
        this.textFieldFrequency.func_146201_a(par1, par2);
        try {
            int newSafetyRadius;
            this.tileEntity.safetyRange = newSafetyRadius = Math.min(500, Math.max(0, Integer.parseInt(this.textFieldTriggerRange.func_146179_b())));
            ICBMClassic.packetHandler.sendToServer(new PacketTile("safeRange_C>S", 2, this.tileEntity).addData(new Object[]{this.tileEntity.safetyRange}));
        }
        catch (NumberFormatException newSafetyRadius) {
            // empty catch block
        }
        try {
            int newAlarmRadius;
            this.tileEntity.alarmRange = newAlarmRadius = Math.min(500, Math.max(0, Integer.parseInt(this.textFieldDetectionRange.func_146179_b())));
            ICBMClassic.packetHandler.sendToServer(new PacketTile("alarmRange_C>S", 3, this.tileEntity).addData(new Object[]{this.tileEntity.alarmRange}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.tileEntity.setFrequency(Integer.parseInt(this.textFieldFrequency.func_146179_b()));
            ICBMClassic.packetHandler.sendToServer(new PacketTile("frequency_C>S", 4, this.tileEntity).addData(new Object[]{this.tileEntity.getFrequency()}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        this.textFieldDetectionRange.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
        this.textFieldTriggerRange.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
        this.textFieldFrequency.func_146192_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.func_146276_q_();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.containerPosX = (this.field_146294_l - this.field_146999_f) / 2;
        this.containerPosY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(this.containerPosX, this.containerPosY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.radarCenter = new Point(this.containerPosX + this.field_146999_f / 3 - 10, this.containerPosY + this.field_147000_g / 2 + 4);
        this.radarMapRadius = 7.0422535f;
        this.info = "";
        this.info2 = "";
        if (this.tileEntity.hasPower()) {
            int range = 4;
            for (Pos pos : this.tileEntity.guiDrawPoints) {
                Point maxPosition;
                RadarObjectType type = RadarObjectType.get(pos.zi());
                double x = pos.x();
                double z = pos.y();
                Point position = new Point(this.radarCenter.x() + (x - (double)this.tileEntity.func_174877_v().func_177958_n()) / (double)this.radarMapRadius, this.radarCenter.y() - (z - (double)this.tileEntity.func_174877_v().func_177952_p()) / (double)this.radarMapRadius);
                switch (type) {
                    case MISSILE: {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_YELLOW_DOT);
                        break;
                    }
                    case MISSILE_IMPACT: {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_RED_DOT);
                        break;
                    }
                    default: {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_WHITE_DOT);
                    }
                }
                this.func_73729_b(position.xi(), position.yi(), 0, 0, 2, 2);
                Point minPosition = (Point)position.add(-range);
                if (!new Rectangle(minPosition, maxPosition = (Point)position.add(range)).isWithin(this.mousePosition)) continue;
                if (type == RadarObjectType.OTHER) {
                    this.info = String.format(LanguageUtility.getLocal("gui.misc.object"), (int)x, (int)z);
                    continue;
                }
                this.info = (type == RadarObjectType.MISSILE ? "\u00a76" : "\u00a74") + String.format(LanguageUtility.getLocal("gui.misc.missile"), (int)x, (int)z);
            }
        }
        if (this.tileEntity.getEnergy() > 0) {
            float energyScale = (float)this.tileEntity.getEnergy() / (float)this.tileEntity.getEnergyBufferSize();
            int textureWidth = 8;
            int textureHeight = 71;
            int height = (int)Math.min(71.0, Math.floor(71.0f * energyScale));
            this.func_73729_b(this.containerPosX + 248, this.containerPosY + 65 + (71 - height), 0, 237 - height, 8, height);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (Mouse.isInsideWindow() && Mouse.getEventButton() == -1) {
            this.mousePosition = new Point(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c, this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1);
            float difference = 500.0f / this.radarMapRadius;
            if (this.mousePosition.x() > this.radarCenter.x() - (double)difference && this.mousePosition.x() < this.radarCenter.x() + (double)difference && this.mousePosition.y() > this.radarCenter.y() - (double)difference && this.mousePosition.y() < this.radarCenter.y() + (double)difference) {
                int xDifference = (int)(this.mousePosition.x() - this.radarCenter.x());
                int yDifference = (int)(this.mousePosition.y() - this.radarCenter.y());
                int xBlockDistance = (int)((float)xDifference * this.radarMapRadius);
                int yBlockDistance = (int)((float)yDifference * this.radarMapRadius);
                this.mouseOverCoords = new Point(this.tileEntity.func_174877_v().func_177958_n() + xBlockDistance, this.tileEntity.func_174877_v().func_177952_p() - yBlockDistance);
            }
        }
        if (!this.textFieldTriggerRange.func_146206_l()) {
            this.textFieldTriggerRange.func_146180_a(this.tileEntity.safetyRange + "");
        }
        if (!this.textFieldDetectionRange.func_146206_l()) {
            this.textFieldDetectionRange.func_146180_a(this.tileEntity.alarmRange + "");
        }
    }
}

