/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.multiblock;

import icbm.classic.api.tile.multiblock.IMultiTile;
import icbm.classic.api.tile.multiblock.IMultiTileHost;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.prefab.inventory.InventoryUtility;
import java.util.Collection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiBlockHelper {
    private static final Logger logger = LogManager.getLogger((String)"VE-MultiBlockHelper");

    public static void buildMultiBlock(World world, IMultiTileHost hostTile, boolean validate, boolean offset) {
        if (world == null) {
            logger.error("MultiBlockHelper: buildMultiBlock was called with a null world by " + hostTile, (Throwable)new RuntimeException());
            return;
        }
        if (hostTile == null) {
            logger.error("MultiBlockHelper: buildMultiBlock was called with a null hostTile ", (Throwable)new RuntimeException());
            return;
        }
        if (BlockReg.multiBlock != null) {
            Collection<BlockPos> placementList = hostTile.getLayoutOfMultiBlock();
            if (placementList != null && !placementList.isEmpty()) {
                int i = 0;
                for (BlockPos location : placementList) {
                    if (location == null) {
                        logger.error("MultiBlockHelper: location[" + i + "] is null, this is most likely in error in " + hostTile);
                        ++i;
                        continue;
                    }
                    if (offset) {
                        location = location.func_177982_a(hostTile.xi(), hostTile.yi(), hostTile.zi());
                    }
                    TileEntity tile = world.func_175625_s(location);
                    if (!validate || tile == null) {
                        if (!world.func_180501_a(location, BlockReg.multiBlock.func_176223_P(), 3)) {
                            logger.error("MultiBlockHelper:  error block was not placed ");
                        }
                        tile = world.func_175625_s(location);
                    }
                    if (tile instanceof IMultiTile) {
                        ((IMultiTile)tile).setHost(hostTile);
                    } else {
                        logger.error("MultiBlockHelper: hostTile at location is not IMultiTile, " + tile);
                    }
                    ++i;
                }
            } else {
                logger.error("Tile[" + hostTile + "] didn't return a structure map");
            }
        } else {
            logger.error("MultiBlock was never registered, this is a critical error and can have negative effects on gameplay. Make sure the block was not disabled in the configs and contact support to ensure nothing is broken", (Throwable)new RuntimeException());
        }
    }

    public static boolean canBuild(World world, IMultiTileHost tile, boolean offset) {
        if (world != null && tile != null && BlockReg.multiBlock != null) {
            return MultiBlockHelper.canBuild(world, ((TileEntity)tile).func_174877_v(), tile.getLayoutOfMultiBlock(), offset);
        }
        return false;
    }

    public static boolean canBuild(World world, BlockPos pos, Collection<BlockPos> map, boolean offset) {
        if (world != null && BlockReg.multiBlock != null && map != null && !map.isEmpty()) {
            for (BlockPos location : map) {
                TileEntity tileEntity;
                IBlockState block;
                if (location == null || !world.func_175667_e(pos)) {
                    return false;
                }
                if (offset) {
                    location = location.func_177971_a((Vec3i)pos);
                }
                if (!(block = world.func_180495_p(location)).func_177230_c().func_176200_f((IBlockAccess)world, location)) {
                    return false;
                }
                if (block.func_177230_c() != BlockReg.multiBlock || !((tileEntity = world.func_175625_s(location)) instanceof IMultiTile) || ((IMultiTile)tileEntity).getHost() == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static void destroyMultiBlockStructure(IMultiTileHost host) {
        MultiBlockHelper.destroyMultiBlockStructure(host, true);
    }

    public static void destroyMultiBlockStructure(IMultiTileHost host, boolean doDrops) {
        MultiBlockHelper.destroyMultiBlockStructure(host, doDrops, false);
    }

    public static void destroyMultiBlockStructure(IMultiTileHost host, boolean doDrops, boolean offset) {
        MultiBlockHelper.destroyMultiBlockStructure(host, doDrops, offset, true);
    }

    public static void destroyMultiBlockStructure(IMultiTileHost host, boolean doDrops, boolean offset, boolean killHost) {
        if (host != null) {
            Collection<BlockPos> map = host.getLayoutOfMultiBlock();
            if (map != null && !map.isEmpty()) {
                BlockPos center = host.getPos();
                for (BlockPos pos : map) {
                    TileEntity tile;
                    if (offset) {
                        pos = pos.func_177971_a((Vec3i)center);
                    }
                    if (!((tile = host.world().func_175625_s(pos)) instanceof IMultiTile) || !((IMultiTile)tile).isHost(host)) continue;
                    ((IMultiTile)tile).setHost(null);
                    host.world().func_175698_g(pos);
                }
                if (doDrops) {
                    InventoryUtility.dropBlockAsItem(((TileEntity)host).func_145831_w(), center, killHost);
                } else if (killHost) {
                    ((TileEntity)host).func_145831_w().func_175698_g(center);
                }
            } else {
                logger.error("MultiBlockHelper >> Tile[" + host + "]'s structure map is empty");
            }
        }
    }
}

