/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.explosive;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.blocks.explosive.PropertyExplosive;
import icbm.classic.content.blocks.explosive.TileEntityExplosive;
import icbm.classic.lib.capability.ex.CapabilityExplosiveStack;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.BlockICBM;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class BlockExplosive
extends BlockICBM {
    public static final PropertyExplosive EX_PROP = new PropertyExplosive();

    public BlockExplosive() {
        super("explosives", Material.field_151590_u);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185854_g);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.func_185473_a(world, pos, this.func_176221_a(state, (IBlockAccess)world, pos));
    }

    public int func_180651_a(IBlockState state) {
        return ((IExplosiveData)state.func_177229_b((IProperty)EX_PROP)).getRegistryID();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IExplosiveData explosiveData = null;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityExplosive && ((TileEntityExplosive)tile).capabilityExplosive != null) {
            explosiveData = ((TileEntityExplosive)tile).capabilityExplosive.getExplosiveData();
        }
        if (explosiveData != null) {
            return state.func_177226_a((IProperty)EX_PROP, explosiveData);
        }
        return state;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isNormalCube(base_state, world, pos);
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION_PROP, EX_PROP});
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        ItemStack stack = placer.func_184586_b(hand);
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)ROTATION_PROP, (Comparable)facing);
        IExplosiveData prop = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(stack.func_77952_i());
        if (prop != null) {
            return state.func_177226_a((IProperty)EX_PROP, (Comparable)prop);
        }
        prop = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(0);
        ICBMClassic.logger().log(Level.ERROR, "Unable to get explosives kind, choosing " + prop.getRegistryName().toString() + " as a fallback.");
        stack.func_77964_b(0);
        return state.func_177226_a((IProperty)EX_PROP, (Comparable)prop);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack itemStack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityExplosive) {
            TileEntityExplosive explosive = (TileEntityExplosive)tile;
            explosive.capabilityExplosive = new CapabilityExplosiveStack(itemStack.func_77946_l());
            if (world.func_175687_A(pos) > 0) {
                BlockExplosive.triggerExplosive(world, pos, false);
            }
            for (EnumFacing rotation : EnumFacing.field_176754_o) {
                Pos position = (Pos)new Pos(pos).add(rotation);
                Block blockId = position.getBlock((IBlockAccess)world);
                if (blockId != Blocks.field_150480_ab && blockId != Blocks.field_150356_k && blockId != Blocks.field_150353_l) continue;
                BlockExplosive.triggerExplosive(world, pos, true);
                break;
            }
            if (entityLiving != null) {
                ICBMClassic.logger().info("ICBMClassic>>BlockExplosive#onBlockPlacedBy: " + entityLiving.func_70005_c_() + " placed " + explosive.capabilityExplosive.getExplosiveData().getRegistryName() + " in: " + pos);
            }
        }
    }

    public void func_189540_a(IBlockState thisBlock, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int power = world.func_175687_A(pos);
        if (power > 0) {
            BlockExplosive.triggerExplosive(world, pos, false);
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IBlockState state = world.func_180495_p(pos.func_177971_a(facing.func_176730_m()));
            Block block = state.func_177230_c();
            if (block != Blocks.field_150480_ab && block != Blocks.field_150356_k && block != Blocks.field_150353_l) continue;
            BlockExplosive.triggerExplosive(world, pos, false);
            return;
        }
    }

    public static void triggerExplosive(World world, BlockPos pos, boolean setFire) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityExplosive) {
            ((TileEntityExplosive)tileEntity).trigger(setFire);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        BlockExplosive.triggerExplosive(world, pos, false);
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (entityPlayer.func_184586_b(hand) != null && entityPlayer.func_184586_b(hand).func_77973_b() == Items.field_151033_d) {
            BlockExplosive.triggerExplosive(world, pos, true);
            return true;
        }
        if (tileEntity instanceof TileEntityExplosive) {
            // empty if block
        }
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_149708_J()) {
            for (int id : ICBMClassicAPI.EX_BLOCK_REGISTRY.getExplosivesIDs()) {
                items.add((Object)new ItemStack((Block)this, 1, id));
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityExplosive();
    }
}

