/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.emptower;

import icbm.classic.ICBMClassic;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.tile.multiblock.IMultiTile;
import icbm.classic.api.tile.multiblock.IMultiTileHost;
import icbm.classic.client.ICBMSounds;
import icbm.classic.content.blast.BlastEMP;
import icbm.classic.content.blocks.emptower.ContainerEMPTower;
import icbm.classic.content.blocks.emptower.GuiEMPTower;
import icbm.classic.content.blocks.multiblock.MultiBlockHelper;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.prefab.inventory.ExternalInventory;
import icbm.classic.prefab.inventory.IInventoryProvider;
import icbm.classic.prefab.tile.IGuiTile;
import icbm.classic.prefab.tile.TilePoweredMachine;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileEMPTower
extends TilePoweredMachine
implements IMultiTileHost,
IPacketIDReceiver,
IGuiTile,
IInventoryProvider<ExternalInventory> {
    public static final int MAX_RADIUS = 150;
    public static final int CHANGE_RADIUS_PACKET_ID = 1;
    public static final int CHANGE_MODE_PACKET_ID = 2;
    public static List<BlockPos> tileMapCache = new ArrayList<BlockPos>();
    public float rotation = 0.0f;
    private float rotationDelta;
    public EMPMode empMode = EMPMode.ALL;
    private int cooldownTicks = 0;
    public int empRadius = 60;
    private boolean _destroyingStructure = false;
    private ExternalInventory inventory;

    @Override
    public ExternalInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new ExternalInventory(this, 2);
        }
        return this.inventory;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer()) {
            if (!this.isReady()) {
                --this.cooldownTicks;
            } else {
                if (this.ticks % 20 == 0 && this.getEnergy() > 0) {
                    ICBMSounds.MACHINE_HUM.play(this.field_145850_b, this.xi(), this.yi(), this.zi(), 0.5f, 0.85f * this.getChargePercentage(), true);
                    this.sendDescPacket();
                }
                if (this.field_145850_b.func_175687_A(this.func_174877_v()) > 0) {
                    this.fire();
                }
            }
        } else {
            this.rotationDelta = (float)(Math.pow(this.getChargePercentage(), 2.0) * 0.5);
            this.rotation += this.rotationDelta;
            if (this.rotation > 360.0f) {
                this.rotation = 0.0f;
            }
        }
    }

    public float getChargePercentage() {
        return Math.min(1.0f, (float)this.getEnergy() / (float)this.getEnergyConsumption());
    }

    @Override
    public boolean read(ByteBuf data, int id, EntityPlayer player, IPacket type) {
        if (!super.read(data, id, player, type)) {
            switch (id) {
                case 1: {
                    this.empRadius = data.readInt();
                    return true;
                }
                case 2: {
                    this.empMode = EMPMode.values()[data.readByte()];
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeInt(this.empRadius);
        buf.writeByte((int)((byte)this.empMode.ordinal()));
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.empRadius = buf.readInt();
        this.empMode = EMPMode.values()[buf.readByte()];
    }

    @Override
    public int getEnergyBufferSize() {
        return Math.max(3000000 * (this.empRadius / 150), 1000000);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.empRadius = par1NBTTagCompound.func_74762_e("empRadius");
        this.empMode = EMPMode.values()[par1NBTTagCompound.func_74771_c("empMode")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74768_a("empRadius", this.empRadius);
        par1NBTTagCompound.func_74774_a("empMode", (byte)this.empMode.ordinal());
        return super.func_189515_b(par1NBTTagCompound);
    }

    public boolean fire() {
        if (this.checkExtract() && this.isReady()) {
            BlastEMP emp = (BlastEMP)new BlastEMP().setBlastWorld(this.field_145850_b).setPosition((double)this.xi() + 0.5, (double)this.yi() + 1.2, (double)this.zi() + 0.5).setBlastSize(this.empRadius);
            switch (this.empMode) {
                default: {
                    emp.setEffectBlocks().setEffectEntities();
                    break;
                }
                case MISSILES_ONLY: {
                    emp.setEffectEntities();
                    break;
                }
                case ELECTRICITY_ONLY: {
                    emp.setEffectBlocks();
                }
            }
            if (emp.buildBlast().runBlast() == BlastState.TRIGGERED) {
                this.extractEnergy();
                this.cooldownTicks = this.getMaxCooldown();
                return true;
            }
            ICBMClassic.logger().warn("TileEmpTower( DIM: " + this.field_145850_b.field_73011_w.getDimension() + ", " + this.func_174877_v() + ") EMP did not trigger, likely was blocked.");
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean isReady() {
        return this.getCooldown() <= 0;
    }

    public int getCooldown() {
        return this.cooldownTicks;
    }

    public int getMaxCooldown() {
        return 120;
    }

    @Override
    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity && this.getLayoutOfMultiBlock().contains(((TileEntity)tileMulti).func_174877_v().func_177973_b((Vec3i)this.func_174877_v()))) {
            tileMulti.setHost(this);
        }
    }

    @Override
    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        if (!this._destroyingStructure && tileMulti instanceof TileEntity && this.getLayoutOfMultiBlock().contains(((TileEntity)tileMulti).func_174877_v().func_177973_b((Vec3i)this.func_174877_v()))) {
            MultiBlockHelper.destroyMultiBlockStructure(this, harvest, true, true);
            return true;
        }
        return false;
    }

    @Override
    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    @Override
    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, EnumHand hand, EnumFacing side, float xHit, float yHit, float zHit) {
        if (this.isServer()) {
            this.openGui(player, 0);
        }
        return true;
    }

    @Override
    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public List<BlockPos> getLayoutOfMultiBlock() {
        return tileMapCache;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerEMPTower(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiEMPTower(player, this);
    }

    static {
        tileMapCache.add(new BlockPos(0, 1, 0));
    }

    public static enum EMPMode {
        ALL,
        MISSILES_ONLY,
        ELECTRICITY_ONLY;

    }
}

