/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.emptower;

import icbm.classic.ICBMClassic;
import icbm.classic.content.blocks.emptower.ContainerEMPTower;
import icbm.classic.content.blocks.emptower.TileEMPTower;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.prefab.gui.GuiContainerBase;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;

public class GuiEMPTower
extends GuiContainerBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("icbmclassic", "textures/gui/gui_empty.png");
    private TileEMPTower tileEntity;
    private GuiTextField textFieldBanJing;
    private int containerWidth;
    private int containerHeight;

    public GuiEMPTower(EntityPlayer player, TileEMPTower tileEntity) {
        super(new ContainerEMPTower(player, tileEntity));
        this.tileEntity = tileEntity;
        this.field_147000_g = 166;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 77, this.field_146295_m / 2 - 10, 50, 20, LanguageUtility.getLocal("gui.empTower.missiles")));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 25, this.field_146295_m / 2 - 10, 65, 20, LanguageUtility.getLocal("gui.empTower.elec")));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 43, this.field_146295_m / 2 - 10, 35, 20, LanguageUtility.getLocal("gui.empTower.both")));
        this.textFieldBanJing = new GuiTextField(0, this.field_146289_q, 72, 28, 30, 12);
        this.textFieldBanJing.func_146203_f(3);
        this.textFieldBanJing.func_146180_a(this.tileEntity.empRadius + "");
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                this.tileEntity.empMode = TileEMPTower.EMPMode.MISSILES_ONLY;
                break;
            }
            case 1: {
                this.tileEntity.empMode = TileEMPTower.EMPMode.ELECTRICITY_ONLY;
                break;
            }
            case 2: {
                this.tileEntity.empMode = TileEMPTower.EMPMode.ALL;
            }
        }
        ICBMClassic.packetHandler.sendToServer(new PacketTile("mode_C>S", 2, this.tileEntity).addData(new Object[]{this.tileEntity.empMode}));
    }

    @Override
    public void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.textFieldBanJing.func_146201_a(par1, par2);
        try {
            int radius;
            this.tileEntity.empRadius = radius = Math.min(Math.max(Integer.parseInt(this.textFieldBanJing.func_146179_b()), 10), 150);
            ICBMClassic.packetHandler.sendToServer(new PacketTile("range_C>S", 1, this.tileEntity).addData(new Object[]{this.tileEntity.empRadius}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void func_73864_a(int x, int y, int par3) throws IOException {
        super.func_73864_a(x, y, par3);
        this.textFieldBanJing.func_146192_a(x - this.containerWidth, y - this.containerHeight, par3);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b("\u00a77" + LanguageUtility.getLocal("gui.empTower.name"), 65, 6, 0x404040);
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.empTower.radius").replaceAll("%p", "        "), 12, 30, 0x404040);
        this.textFieldBanJing.func_146194_f();
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.empTower.effect"), 12, 55, 0x404040);
        String mode = LanguageUtility.getLocal("gui.empTower.effectDebilitate");
        if (this.tileEntity.empMode == TileEMPTower.EMPMode.MISSILES_ONLY) {
            mode = LanguageUtility.getLocal("gui.empTower.effectDisrupt");
        } else if (this.tileEntity.empMode == TileEMPTower.EMPMode.ELECTRICITY_ONLY) {
            mode = LanguageUtility.getLocal("gui.empTower.effectDeplete");
        }
        this.field_146289_q.func_78276_b(LanguageUtility.getLocal("gui.empTower.mode") + " " + mode, 12, 105, 0x404040);
        String color = "\u00a74";
        String status = LanguageUtility.getLocal("gui.misc.idle");
        if (!this.tileEntity.hasPower()) {
            status = LanguageUtility.getLocal("gui.misc.nopower");
        } else {
            color = "\u00a72";
            status = LanguageUtility.getLocal("gui.empTower.ready");
        }
        this.field_146289_q.func_78276_b(color + LanguageUtility.getLocal("gui.misc.status") + " " + status, 12, 120, 0x404040);
        this.field_146289_q.func_78276_b("Energy: " + this.tileEntity.getEnergy() + "/" + this.tileEntity.getEnergyBufferSize(), 12, 150, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        int containerPosX = (this.field_146294_l - this.field_146999_f) / 2;
        int containerPosY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        this.containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(this.containerWidth, this.containerHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tileEntity.getEnergy() > 0) {
            float energyScale = (float)this.tileEntity.getEnergy() / (float)this.tileEntity.getEnergyBufferSize();
            int textureX = 176;
            int textureWidth = 8;
            int textureHeight = 71;
            int height = (int)Math.min(71.0, Math.floor(71.0f * energyScale));
            this.func_73729_b(containerPosX + 168, containerPosY + 65 + (71 - height), 176, 71 - height, 8, height);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.textFieldBanJing.func_146206_l()) {
            this.textFieldBanJing.func_146180_a(this.tileEntity.empRadius + "");
        }
    }
}

