/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.api.caps.IMissile;
import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.blast.Blast;
import icbm.classic.content.blast.thread.ThreadLargeExplosion;
import icbm.classic.content.blocks.explosive.TileEntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.reg.BlockReg;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;

public class BlastSonic
extends Blast
implements IBlastTickable {
    private boolean hasShockWave = false;

    public Blast setShockWave() {
        this.hasShockWave = true;
        return this;
    }

    public void firstTick() {
        this.createAndStartThread(new ThreadLargeExplosion(this, (int)this.getBlastRadius(), this.getBlastRadius() * 2.0f, this.field_77283_e));
        if (this.hasShockWave) {
            ICBMSounds.HYPERSONIC.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        } else {
            ICBMSounds.SONICWAVE.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        if (callCount <= 0) {
            this.firstTick();
        }
        int radius = Math.max(1, this.callCount);
        if (callCount % 4 == 0 && this.isThreadCompleted()) {
            if (!this.getThreadResults().isEmpty()) {
                Iterator it = this.getThreadResults().iterator();
                while (it.hasNext()) {
                    BlockPos targetPosition = (BlockPos)it.next();
                    double distance = this.location.distance((Vec3i)targetPosition);
                    if (!(distance <= (double)radius)) continue;
                    it.remove();
                    IBlockState blockState = this.field_77287_j.func_180495_p(targetPosition);
                    Block block = blockState.func_177230_c();
                    if (block.isAir(blockState, (IBlockAccess)this.field_77287_j, targetPosition) || !(blockState.func_185887_b(this.field_77287_j, targetPosition) >= 0.0f)) continue;
                    if (block == BlockReg.blockExplosive) {
                        ((TileEntityExplosive)this.world().func_175625_s(targetPosition)).trigger(false);
                    }
                    this.world().func_175698_g(targetPosition);
                    if (block instanceof BlockFluidBase || block instanceof IFluidBlock || !((double)this.world().field_73012_v.nextFloat() < 0.1)) continue;
                    this.world().func_72838_d((Entity)new EntityFlyingBlock(this.world(), targetPosition, blockState));
                }
            } else {
                this.isAlive = false;
                if (ConfigDebug.DEBUG_THREADS) {
                    String msg = String.format("BlastSonic#doPostExplode() -> Thread failed to find blocks to edit. Either thread failed or no valid blocks were found in range.\nWorld = %s \nThread = %s\nSize = %s\nPos = %s", this.field_77287_j, this.getThread(), Float.valueOf(this.field_77280_f), this.location);
                    ICBMClassic.logger().error(msg);
                }
            }
        }
        int entityEffectRadius = 2 * this.callCount;
        AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - (double)entityEffectRadius, this.location.y() - (double)entityEffectRadius, this.location.z() - (double)entityEffectRadius, this.location.x() + (double)entityEffectRadius, this.location.y() + (double)entityEffectRadius, this.location.z() + (double)entityEffectRadius);
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        for (Entity entity : allEntities) {
            if (entity instanceof IMissile) {
                ((IMissile)entity).destroyMissile(true);
                continue;
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) continue;
            double xDelta = entity.field_70165_t - this.location.x();
            double yDelta = entity.field_70163_u - this.location.y();
            double zDelta = entity.field_70161_v - this.location.z();
            float distance = MathHelper.func_76133_a((double)(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta));
            xDelta /= (double)distance;
            yDelta /= (double)distance;
            zDelta /= (double)distance;
            double scale = Math.max(0.0f, 1.0f - distance / this.getBlastRadius()) * 3.0f;
            entity.field_70159_w += (xDelta *= scale) * (double)this.world().field_73012_v.nextFloat() * 0.2;
            entity.field_70181_x += Math.abs((yDelta *= scale) * (double)this.world().field_73012_v.nextFloat()) * 1.0;
            entity.field_70179_y += (zDelta *= scale) * (double)this.world().field_73012_v.nextFloat() * 0.2;
        }
        return (float)this.callCount > this.getBlastRadius();
    }
}

