/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.config.ConfigBlast;
import icbm.classic.content.blast.BlastBeam;
import icbm.classic.content.potion.CustomPotionEffect;
import icbm.classic.content.potion.PoisonFrostBite;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastEndothermic
extends BlastBeam {
    public BlastEndothermic() {
        this.red = 0.0f;
        this.green = 0.3f;
        this.blue = 0.7f;
    }

    @Override
    protected void mutateBlocks(List<BlockPos> edits) {
        double radius = this.getBlastRadius();
        double radiusDecay = Math.max(1.0, radius * 0.3);
        for (BlockPos targetPosition : edits) {
            double delta_x = this.location.xi() - targetPosition.func_177958_n();
            double delta_y = this.location.yi() - targetPosition.func_177956_o();
            double delta_z = this.location.zi() - targetPosition.func_177952_p();
            double distance = Math.sqrt(delta_x * delta_x + delta_y * delta_y + delta_z * delta_z);
            double distanceScale = 1.0 - distance / radius;
            IBlockState blockState = this.field_77287_j.func_180495_p(targetPosition);
            if (!(distance <= radiusDecay) && !(Math.random() < distanceScale)) continue;
            if (blockState.func_185904_a() == Material.field_151586_h) {
                this.world().func_180501_a(targetPosition, Blocks.field_150432_aD.func_176223_P(), 3);
            } else if (blockState.func_177230_c() == Blocks.field_150480_ab) {
                this.field_77287_j.func_175698_g(targetPosition);
            } else if (blockState.func_177230_c() == Blocks.field_150353_l) {
                this.field_77287_j.func_175656_a(targetPosition, Blocks.field_150343_Z.func_176223_P());
            } else if (blockState.func_177230_c() == Blocks.field_150356_k) {
                int level = Math.min(8, Math.max(1, (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) / 2));
                this.field_77287_j.func_180501_a(targetPosition, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(level)), 3);
            } else if (blockState.func_177230_c() == Blocks.field_189877_df) {
                this.field_77287_j.func_180501_a(targetPosition, Blocks.field_150348_b.func_176223_P(), 3);
            } else if (blockState.func_177230_c() == Blocks.field_150424_aL) {
                this.field_77287_j.func_180501_a(targetPosition, Blocks.field_150346_d.func_176223_P(), 3);
            } else if (blockState.func_177230_c() == Blocks.field_150425_aM) {
                if (this.field_77287_j.field_73012_v.nextBoolean()) {
                    this.field_77287_j.func_180501_a(targetPosition, Blocks.field_150354_m.func_176223_P(), 3);
                } else {
                    this.field_77287_j.func_180501_a(targetPosition, Blocks.field_150351_n.func_176223_P(), 3);
                }
            } else if (blockState.func_185904_a() == Material.field_151578_c || blockState.func_185904_a() == Material.field_151577_b) {
                if (this.field_77287_j.field_73012_v.nextBoolean()) {
                    this.world().func_180501_a(targetPosition, Blocks.field_150432_aD.func_176223_P(), 3);
                } else {
                    this.world().func_180501_a(targetPosition, Blocks.field_150433_aE.func_176223_P(), 3);
                }
            }
            if (!(Math.random() < distanceScale)) continue;
            BlastEndothermic.tryPlaceSnow(this.field_77287_j, targetPosition.func_177984_a(), false);
        }
    }

    private static void tryPlaceSnow(World world, BlockPos pos, boolean random) {
        if (!random || world.field_73012_v.nextBoolean()) {
            IBlockState blockState = world.func_180495_p(pos);
            IBlockState blockStateUnder = world.func_180495_p(pos.func_177977_b());
            if (blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos) && Blocks.field_150431_aC.func_176196_c(world, pos) && blockStateUnder.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) {
                world.func_180501_a(pos, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1 + world.field_73012_v.nextInt(7))), 3);
            }
        }
    }

    @Override
    protected void onBlastCompleted() {
        super.onBlastCompleted();
        List livingEntities = this.world().func_72872_a(EntityLiving.class, new AxisAlignedBB(this.location.x() - (double)this.getBlastRadius(), this.location.y() - (double)this.getBlastRadius(), this.location.z() - (double)this.getBlastRadius(), this.location.x() + (double)this.getBlastRadius(), this.location.y() + (double)this.getBlastRadius(), this.location.z() + (double)this.getBlastRadius()));
        if (livingEntities != null && !livingEntities.isEmpty()) {
            for (EntityLiving entity : livingEntities) {
                if (entity == null || !entity.func_70089_S()) continue;
                entity.func_70690_d((PotionEffect)new CustomPotionEffect(PoisonFrostBite.INSTANCE, 1200, 1, null));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 2400, 2));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2400, 4));
            }
        }
        if (ConfigBlast.ALLOW_DAY_NIGHT && this.world().func_82736_K().func_82766_b("doDaylightCycle")) {
            this.world().func_72877_b(1200L);
        }
    }
}

