/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.command.sub;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.command.imp.SubCommand;
import icbm.classic.lib.explosive.ExplosiveHandler;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class SubCommandBlast
extends SubCommand {
    public String func_71517_b() {
        return "blast";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blast";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1 && args[0].equalsIgnoreCase("list")) {
            String names = "Explosive Types: ";
            for (IExplosiveData data : ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosives()) {
                names = names + data.getRegistryName();
                names = names + ", ";
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(names.substring(names.length() - 2)));
        } else if (args.length >= 1 && args[0].equalsIgnoreCase("spread")) {
            int spread = SubCommandBlast.func_175755_a((String)args[1]);
            for (int x = -spread; x <= spread; ++x) {
                for (int z = -spread; z <= spread; ++z) {
                    String[] parms = new String[]{args[2], args[3], args[4] + x * 100, args[5], args[6] + x * 100, args[7]};
                    this.func_184881_a(server, sender, parms);
                }
            }
        } else if (args.length >= 2) {
            double z;
            double y;
            double x;
            World world;
            String explosive_id = args[0];
            float scale = Float.parseFloat(args.length == 2 ? args[1] : args[5]);
            if (scale <= 0.0f) {
                throw new WrongUsageException("Scale must be greater than zero!", new Object[0]);
            }
            IExplosiveData explosiveData = ICBMClassicHelpers.getExplosive(explosive_id, true);
            if (explosiveData == null) {
                throw new WrongUsageException("Could not find explosive by ID [" + explosive_id + "]", new Object[0]);
            }
            if (args.length == 6) {
                world = args[1].equals("~") && !(sender instanceof MinecraftServer) ? sender.func_130014_f_() : DimensionManager.getWorld((int)Integer.getInteger(args[1]));
                x = this.getNumber(sender, args[2], sender.func_174791_d().field_72450_a);
                y = this.getNumber(sender, args[3], sender.func_174791_d().field_72448_b);
                z = this.getNumber(sender, args[4], sender.func_174791_d().field_72449_c);
            } else if (!(sender instanceof MinecraftServer)) {
                world = sender.func_130014_f_();
                x = sender.func_174791_d().field_72450_a;
                y = sender.func_174791_d().field_72448_b;
                z = sender.func_174791_d().field_72449_c;
            } else {
                throw new WrongUsageException("/icbmc remove <all/missile/explosion> dim_id x y z radius", new Object[0]);
            }
            if (world != null) {
                ExplosiveHandler.createExplosion(null, world, x, y, z, explosiveData.getRegistryID(), scale, null);
                sender.func_145747_a((ITextComponent)new TextComponentString("Generated blast with explosive [" + explosiveData.getRegistryName() + "] with scale " + scale + " at location " + new BlockPos(x, y, z)));
            } else {
                throw new WrongUsageException("Failed to get a world instance from arguments or sender.", new Object[0]);
            }
        }
    }

    protected double getNumber(ICommandSender sender, String value, double alt) throws WrongUsageException {
        if (value.equals("~")) {
            if (!(sender instanceof MinecraftServer)) {
                return alt;
            }
            throw new WrongUsageException("'~' can't be used from console", new Object[0]);
        }
        if (value.startsWith("~")) {
            if (!(sender instanceof MinecraftServer)) {
                return alt + Double.parseDouble(value.substring(1, value.length()));
            }
            throw new WrongUsageException("'~' can't be used from console", new Object[0]);
        }
        return Double.parseDouble(value);
    }
}

