/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.command;

import icbm.classic.command.imp.SubCommand;
import icbm.classic.command.sub.SubCommandBlast;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityFragments;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.lib.explosive.ExplosiveHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class CommandICBM
extends CommandBase {
    private final Map<String, SubCommand> subCommandMap = new HashMap<String, SubCommand>();
    private final String id;

    public CommandICBM(String id) {
        this.id = id;
        this.subCommandMap.put("blast", new SubCommandBlast());
    }

    public String func_71517_b() {
        return this.id;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.id;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.displayHelp(sender, false);
        } else {
            String subCommand = args[0].toLowerCase();
            if (this.subCommandMap.containsKey(subCommand)) {
                this.subCommandMap.get(subCommand).func_184881_a(server, sender, this.removeFront(args));
            } else if (args[0].equalsIgnoreCase("remove")) {
                this.commandRemove(server, sender, args);
            } else if (args[0].equalsIgnoreCase("lag")) {
                this.commandLag(server, sender, args);
            } else if (args[0].equalsIgnoreCase("debug")) {
                this.commandLag(server, sender, args);
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cUnknown command! Use '" + this.func_71518_a(sender) + " help' for more a list of commands"));
            }
        }
    }

    protected String[] removeFront(String[] args) {
        if (args.length == 0 || args.length == 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(args, 1, args.length);
    }

    protected void displayHelp(ICommandSender sender, boolean error) {
        if (sender instanceof EntityPlayer) {
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc blast list"));
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc blast <id> <scale>"));
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc blast <id> <x> <y> <z> <scale>"));
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc remove <all/missiles/explosions> [radius]"));
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc remove <all/missiles/explosions> <dim> <x> <y> <z> <radius>"));
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc lag [radius]"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc blast list"));
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc blast <id> <dim> <x> <y> <z> <scale>"));
            sender.func_145747_a((ITextComponent)new TextComponentString((error ? "\u00a7c" : "") + "/icbmc remove <all/missiles/explosions> <dim> <x> <y> <z> <radius>"));
        }
    }

    protected void commandRemove(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        if (args.length >= 2) {
            String typeString;
            boolean remove_explosives;
            String type_arg = args[1];
            boolean remove_all = type_arg.equalsIgnoreCase("all");
            boolean remove_missiles = remove_all || type_arg.equalsIgnoreCase("missiles") || type_arg.equalsIgnoreCase("missile");
            boolean bl = remove_explosives = remove_all || type_arg.equalsIgnoreCase("explosions") || type_arg.equalsIgnoreCase("explosion") || type_arg.equalsIgnoreCase("explosive") || type_arg.equalsIgnoreCase("explosives") || type_arg.equalsIgnoreCase("ex");
            String string = remove_all ? "entities" : (remove_missiles ? "missiles" : (typeString = remove_explosives ? "explosions" : null));
            if (typeString != null) {
                double z;
                double y;
                double x;
                World world;
                int range;
                boolean hasRange;
                boolean bl2 = hasRange = args.length == 3 || args.length == 7;
                int n = args.length == 3 ? this.parseRadius(args[2]) : (range = args.length == 7 ? this.parseRadius(args[6]) : -1);
                if (args.length == 6) {
                    world = DimensionManager.getWorld((int)Integer.getInteger(args[2]));
                    x = Double.parseDouble(args[3]);
                    y = Double.parseDouble(args[4]);
                    z = Double.parseDouble(args[5]);
                } else if (!(sender instanceof MinecraftServer)) {
                    world = sender.func_130014_f_();
                    x = sender.func_174791_d().field_72450_a;
                    y = sender.func_174791_d().field_72448_b;
                    z = sender.func_174791_d().field_72449_c;
                } else {
                    throw new WrongUsageException("/icbmc remove <all/missile/explosion> dim_id x y z radius", new Object[0]);
                }
                if (world != null) {
                    List<Entity> entities = this.getEntities(world, x, y, z, range);
                    int count = 0;
                    for (int i = 0; i < entities.size(); ++i) {
                        Entity entity = entities.get(i);
                        if (entity == null || entity.field_70128_L) continue;
                        boolean isExplosive = entity instanceof EntityExplosive;
                        boolean isMissile = this.isMissile(entity);
                        boolean isICBM = this.isICBMEntity(entity);
                        if (!(remove_explosives && isExplosive || remove_missiles && isMissile) && (!remove_all || !isICBM)) continue;
                        entity.func_70106_y();
                        ++count;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Removed '" + count + "' ICBM entities " + (hasRange ? "within " + range + "meters" : "from the world")));
                    return;
                }
                throw new WrongUsageException("Failed to get a world instance from arguments or sender.", new Object[0]);
            }
        }
        throw new WrongUsageException("'/icbmc remove <all/missile/explosion> [radius]' or '/icbmc remove <all/missile/explosion> <x> <y> <z> <radius>'", new Object[0]);
    }

    protected void commandLag(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        double range = args.length > 1 ? Double.parseDouble(args[1]) : 1000.0;
        List<Entity> entities = this.getEntities(sender.func_130014_f_(), sender.func_174791_d().field_72450_a, sender.func_174791_d().field_72448_b, sender.func_174791_d().field_72449_c, range);
        int count = 0;
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity = entities.get(i);
            if (entity == null || entity.field_70128_L || !this.isICBMEntity(entity)) continue;
            entity.func_70106_y();
            ++count;
        }
        int blasts = ExplosiveHandler.removeNear(sender.func_130014_f_(), sender.func_174791_d().field_72450_a, sender.func_174791_d().field_72448_b, sender.func_174791_d().field_72449_c, range);
        sender.func_145747_a((ITextComponent)new TextComponentString("Removed '" + count + "' ICBM entities within " + range + " meters"));
        sender.func_145747_a((ITextComponent)new TextComponentString("Removed '" + blasts + "' blast controllers within " + range + " meters"));
    }

    private boolean isICBMEntity(Entity entity) {
        return entity instanceof EntityFragments || entity instanceof EntityFlyingBlock || this.isMissile(entity) || entity instanceof EntityExplosive;
    }

    private boolean isMissile(Entity entity) {
        return entity instanceof EntityMissile;
    }

    protected List<Entity> getEntities(World world, double x, double y, double z, double range) {
        if (range > 0.0) {
            AxisAlignedBB bb = new AxisAlignedBB(x - range, y - range, z - range, x + range, y + range, z + range);
            return world.func_72872_a(Entity.class, bb);
        }
        if (range == -1.0) {
            return world.field_72996_f;
        }
        return new ArrayList<Entity>();
    }

    private int parseRadius(String input) throws WrongUsageException {
        try {
            int radius = Integer.parseInt(input);
            if (radius <= 0) {
                throw new WrongUsageException("Radius must be greater than zero!", new Object[0]);
            }
            return radius;
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("Invalid radius!", new Object[0]);
        }
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? CommandICBM.func_71530_a((String[])args, (String[])new String[]{"remove", "emp"}) : (args.length == 2 && args[0].equalsIgnoreCase("remove") ? CommandICBM.func_71530_a((String[])args, (String[])new String[]{"all", "missile", "explosion"}) : new ArrayList<String>());
    }

    public int compareTo(ICommand par1Obj) {
        return super.compareTo(par1Obj);
    }
}

