/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client;

import icbm.classic.ICBMClassic;
import icbm.classic.api.EnumTier;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.content.blocks.explosive.ItemBlockExplosive;
import icbm.classic.content.items.ItemBombCart;
import icbm.classic.content.items.ItemGrenade;
import icbm.classic.content.items.ItemMissile;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.content.reg.ItemReg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ICBMCreativeTab
extends CreativeTabs {
    public ItemStack itemStack = null;
    public List<Item> definedTabItemsInOrder = new ArrayList<Item>();

    public ICBMCreativeTab(String name) {
        super(name);
    }

    public void init() {
        this.definedTabItemsInOrder.clear();
        this.orderItem(BlockReg.blockLaunchBase);
        this.orderItem(BlockReg.blockLaunchScreen);
        this.orderItem(BlockReg.blockLaunchSupport);
        this.orderItem(BlockReg.blockEmpTower);
        this.orderItem(BlockReg.blockRadarStation);
        this.orderItem(BlockReg.blockConcrete);
        this.orderItem(BlockReg.blockReinforcedGlass);
        this.orderItem(BlockReg.blockSpikes);
        this.orderItem(ItemReg.itemRocketLauncher);
        this.orderItem(ItemReg.itemRadarGun);
        this.orderItem(ItemReg.itemRemoteDetonator);
        this.orderItem(ItemReg.itemLaserDetonator);
        this.orderItem(ItemReg.itemTracker);
        this.orderItem(ItemReg.itemSignalDisrupter);
        this.orderItem(ItemReg.itemDefuser);
        this.orderItem(ItemReg.itemBattery);
        this.orderItem(BlockReg.blockExplosive);
        this.orderItem(ItemReg.itemMissile);
        this.orderItem(ItemReg.itemGrenade);
        this.orderItem(ItemReg.itemBombCart);
        for (Item item : Item.field_150901_e) {
            if (item == null) continue;
            for (CreativeTabs tab : item.getCreativeTabs()) {
                if (tab != this || this.definedTabItemsInOrder.contains(item)) continue;
                this.orderItem(item);
            }
        }
    }

    private void orderItem(Block item) {
        this.orderItem(Item.func_150898_a((Block)item));
    }

    private void orderItem(Item item) {
        this.definedTabItemsInOrder.add(item);
    }

    public void func_78018_a(NonNullList<ItemStack> list) {
        this.definedTabItemsInOrder.forEach(item -> this.collectSubItems((Item)item, list));
    }

    protected void collectSubItems(Item item, NonNullList<ItemStack> list) {
        NonNullList temp_list = NonNullList.func_191196_a();
        item.func_150895_a((CreativeTabs)this, temp_list);
        if (item instanceof ItemBlockExplosive || item instanceof ItemMissile || item instanceof ItemBombCart) {
            temp_list.sort((e1, e2) -> {
                EnumTier tier1 = ICBMClassicHelpers.getExplosive(e1.func_77952_i(), true).getTier();
                EnumTier tier2 = ICBMClassicHelpers.getExplosive(e2.func_77952_i(), true).getTier();
                if (tier1 != null && tier2 != null) {
                    return tier1.ordinal() - tier2.ordinal();
                }
                return 0;
            });
            temp_list.sort((e1, e2) -> {
                EnumTier tier2;
                EnumTier tier1 = ICBMClassicHelpers.getExplosive(e1.func_77952_i(), true).getTier();
                if (tier1 != (tier2 = ICBMClassicHelpers.getExplosive(e2.func_77952_i(), true).getTier())) {
                    return 0;
                }
                return e1.func_77952_i() - e2.func_77952_i();
            });
        } else if (item instanceof ItemGrenade) {
            temp_list.sort((e1, e2) -> e1.func_77952_i() - e2.func_77952_i());
        }
        this.mergeIntoList(item, list, (NonNullList<ItemStack>)temp_list);
    }

    protected void mergeIntoList(Item item, NonNullList<ItemStack> list, NonNullList<ItemStack> listToMerge) {
        for (ItemStack stack : listToMerge) {
            if (stack.func_77973_b() != null) {
                list.add((Object)stack);
                continue;
            }
            ICBMClassic.logger().error("Item: " + item + "  attempted to add a stack with a null item to creative tab " + (Object)((Object)this));
        }
    }

    public ItemStack func_78016_d() {
        if (this.itemStack == null || this.itemStack.func_77973_b() == null) {
            if (this.itemStack == null) {
                ICBMClassic.logger().error("ItemStack used for creative tab " + this.func_78013_b() + " is null");
            } else {
                ICBMClassic.logger().error("ItemStack used for creative tab " + this.func_78013_b() + " contains a null Item reference");
            }
            NonNullList list = NonNullList.func_191196_a();
            this.func_78018_a((NonNullList<ItemStack>)list);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                ItemStack stack;
                this.itemStack = stack = (ItemStack)iterator.next();
                return this.itemStack;
            }
            this.itemStack = new ItemStack(Blocks.field_150379_bu);
        }
        return this.itemStack;
    }

    protected void add(NonNullList<ItemStack> list, Item item) {
        if (item != null) {
            item.func_150895_a((CreativeTabs)this, list);
        }
    }

    protected void add(NonNullList<ItemStack> list, Block block) {
        if (block != null) {
            block.func_149666_a((CreativeTabs)this, list);
        }
    }
}

