/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client;

import icbm.classic.api.EnumTier;
import icbm.classic.api.ExplosiveRefs;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.client.mapper.BlockModelMapperExplosive;
import icbm.classic.client.mapper.ItemModelMapperExplosive;
import icbm.classic.client.render.entity.RenderCreeperXmas;
import icbm.classic.client.render.entity.RenderEntityBlock;
import icbm.classic.client.render.entity.RenderExBlock;
import icbm.classic.client.render.entity.RenderExplosion;
import icbm.classic.client.render.entity.RenderFragments;
import icbm.classic.client.render.entity.RenderGrenade;
import icbm.classic.client.render.entity.RenderLightBeam;
import icbm.classic.client.render.entity.RenderMissile;
import icbm.classic.client.render.entity.RenderSeat;
import icbm.classic.client.render.entity.RenderSkeletonXmas;
import icbm.classic.client.render.entity.RenderSnowmanXmas;
import icbm.classic.client.render.entity.RenderZombieXmas;
import icbm.classic.content.blocks.emptower.TESREMPTower;
import icbm.classic.content.blocks.emptower.TileEMPTower;
import icbm.classic.content.blocks.launcher.base.TESRLauncherBase;
import icbm.classic.content.blocks.launcher.base.TileLauncherBase;
import icbm.classic.content.blocks.launcher.cruise.TESRCruiseLauncher;
import icbm.classic.content.blocks.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.blocks.launcher.frame.TESRLauncherFrame;
import icbm.classic.content.blocks.launcher.frame.TileLauncherFrame;
import icbm.classic.content.blocks.launcher.screen.TESRLauncherScreen;
import icbm.classic.content.blocks.launcher.screen.TileLauncherScreen;
import icbm.classic.content.blocks.radarstation.TESRRadarStation;
import icbm.classic.content.blocks.radarstation.TileRadarStation;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityFragments;
import icbm.classic.content.entity.EntityGrenade;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.content.entity.mobs.EntityXmasCreeper;
import icbm.classic.content.entity.mobs.EntityXmasSkeleton;
import icbm.classic.content.entity.mobs.EntityXmasSkeletonBoss;
import icbm.classic.content.entity.mobs.EntityXmasSnowman;
import icbm.classic.content.entity.mobs.EntityXmasZombie;
import icbm.classic.content.entity.mobs.EntityXmasZombieBoss;
import icbm.classic.content.items.ItemCrafting;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.prefab.tile.BlockICBM;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="icbmclassic", value={Side.CLIENT})
public class ClientReg {
    private static final Map<IExplosiveData, ModelResourceLocation> grenadeModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();
    private static final Map<IExplosiveData, ModelResourceLocation> missileModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();
    private static final Map<IExplosiveData, Map<EnumFacing, ModelResourceLocation>> blockModelMap = new HashMap<IExplosiveData, Map<EnumFacing, ModelResourceLocation>>();
    private static final Map<IExplosiveData, ModelResourceLocation> itemBlockModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();
    private static final Map<IExplosiveData, ModelResourceLocation> cartModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();

    private static void clearModelCache() {
        grenadeModelMap.clear();
        missileModelMap.clear();
        blockModelMap.clear();
        itemBlockModelMap.clear();
        cartModelMap.clear();
    }

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        OBJLoader.INSTANCE.addDomain("icbmclassic");
        ClientReg.clearModelCache();
        ClientReg.newBlockModel(BlockReg.blockReinforcedGlass, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockGlassPlate, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockGlassButton, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockSpikes, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockSpikes, 1, "inventory", "_poison");
        ClientReg.newBlockModel(BlockReg.blockSpikes, 2, "inventory", "_fire");
        ClientReg.newBlockModel(BlockReg.blockConcrete, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockConcrete, 1, "inventory", "_compact");
        ClientReg.newBlockModel(BlockReg.blockConcrete, 2, "inventory", "_reinforced");
        ClientReg.newBlockModel(BlockReg.blockCruiseLauncher, 0, "inventory", "");
        ClientReg.registerExBlockRenders();
        ClientReg.registerGrenadeRenders();
        ClientReg.registerCartRenders();
        ClientReg.registerMissileRenders();
        ClientReg.newBlockModel(BlockReg.blockEmpTower, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockRadarStation, 0, "inventory", "");
        ClientReg.registerLauncherPart(BlockReg.blockLaunchBase);
        ClientReg.registerLauncherPart(BlockReg.blockLaunchSupport);
        ClientReg.registerLauncherPart(BlockReg.blockLaunchScreen);
        ClientReg.registerMultiBlockRenders();
        ClientReg.newItemModel(ItemReg.itemPoisonPowder, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemSulfurDust, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemSaltpeterDust, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemAntidote, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemSignalDisrupter, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemTracker, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemDefuser, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemRadarGun, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemRemoteDetonator, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemLaserDetonator, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemRocketLauncher, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemBattery, 0, "inventory", "");
        ClientReg.registerCraftingRender(ItemReg.itemIngot);
        ClientReg.registerCraftingRender(ItemReg.itemIngotClump);
        ClientReg.registerCraftingRender(ItemReg.itemPlate);
        ClientReg.registerCraftingRender(ItemReg.itemCircuit);
        ClientReg.registerCraftingRender(ItemReg.itemWire);
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosive.class, manager -> new RenderExBlock(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityFlyingBlock.class, manager -> new RenderEntityBlock(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosion.class, manager -> new RenderExplosion(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, manager -> new RenderGrenade(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightBeam.class, manager -> new RenderLightBeam(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityFragments.class, manager -> new RenderFragments(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityPlayerSeat.class, manager -> new RenderSeat(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, manager -> {
            RenderMissile.INSTANCE = new RenderMissile(manager);
            return RenderMissile.INSTANCE;
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasSkeleton.class, manager -> new RenderSkeletonXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasSkeletonBoss.class, manager -> new RenderSkeletonXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasSnowman.class, manager -> new RenderSnowmanXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasZombie.class, manager -> new RenderZombieXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasZombieBoss.class, manager -> new RenderZombieXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasCreeper.class, manager -> new RenderCreeperXmas(manager));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEMPTower.class, (TileEntitySpecialRenderer)new TESREMPTower());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRadarStation.class, (TileEntitySpecialRenderer)new TESRRadarStation());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherFrame.class, (TileEntitySpecialRenderer)new TESRLauncherFrame());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherBase.class, (TileEntitySpecialRenderer)new TESRLauncherBase());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherScreen.class, (TileEntitySpecialRenderer)new TESRLauncherScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCruiseLauncher.class, (TileEntitySpecialRenderer)new TESRCruiseLauncher());
    }

    protected static void registerMultiBlockRenders() {
        ModelLoader.setCustomStateMapper((Block)BlockReg.multiBlock, block -> Collections.emptyMap());
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)BlockReg.multiBlock), (ResourceLocation[])new ResourceLocation[0]);
    }

    protected static void registerExBlockRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_BLOCK_REGISTRY.getExplosives()) {
            HashMap<EnumFacing, ModelResourceLocation> facingModelMap = new HashMap<EnumFacing, ModelResourceLocation>();
            String resourcePath = data.getRegistryName().func_110624_b() + ":explosives/" + data.getRegistryName().func_110623_a();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                facingModelMap.put(facing, new ModelResourceLocation(resourcePath, "explosive=" + data.getRegistryName().toString().replace(":", "_") + ",rotation=" + facing));
            }
            blockModelMap.put(data, facingModelMap);
            itemBlockModelMap.put(data, new ModelResourceLocation(resourcePath, "inventory"));
        }
        ModelLoader.setCustomStateMapper((Block)BlockReg.blockExplosive, (IStateMapper)new BlockModelMapperExplosive(blockModelMap, blockModelMap.get(ExplosiveRefs.CONDENSED).get(EnumFacing.UP)));
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)BlockReg.blockExplosive), (ItemMeshDefinition)new ItemModelMapperExplosive(itemBlockModelMap, itemBlockModelMap.get(ExplosiveRefs.CONDENSED)));
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)BlockReg.blockExplosive), (ResourceLocation[])itemBlockModelMap.values().stream().map(mrl -> new ResourceLocation(mrl.func_110624_b(), mrl.func_110623_a())).collect(Collectors.toList()).toArray(new ResourceLocation[itemBlockModelMap.values().size()]));
    }

    protected static void registerLauncherPart(Block block) {
        final String resourcePath = block.getRegistryName().toString();
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(resourcePath, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        for (EnumTier tier : new EnumTier[]{EnumTier.ONE, EnumTier.TWO, EnumTier.THREE}) {
            IBlockState state = block.func_176223_P().func_177226_a((IProperty)BlockICBM.TIER_PROP, (Comparable)((Object)tier)).func_177226_a((IProperty)BlockICBM.ROTATION_PROP, (Comparable)EnumFacing.UP);
            String properties_string = ClientReg.getPropertyString(state.func_177228_b(), new String[0]);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)tier.ordinal(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, properties_string));
        }
    }

    protected static void registerGrenadeRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_GRENADE_REGISTRY.getExplosives()) {
            String resourcePath = data.getRegistryName().func_110624_b() + ":grenades/" + data.getRegistryName().func_110623_a();
            grenadeModelMap.put(data, new ModelResourceLocation(resourcePath, "inventory"));
        }
        ModelLoader.registerItemVariants((Item)ItemReg.itemGrenade, (ResourceLocation[])((ResourceLocation[])grenadeModelMap.values().stream().map(model -> new ResourceLocation(model.func_110624_b() + ":" + model.func_110623_a())).toArray(ResourceLocation[]::new)));
        ModelLoader.setCustomMeshDefinition((Item)ItemReg.itemGrenade, (ItemMeshDefinition)new ItemModelMapperExplosive(grenadeModelMap, grenadeModelMap.get(ExplosiveRefs.CONDENSED)));
    }

    protected static void registerCartRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_MINECART_REGISTRY.getExplosives()) {
            String resourcePath = data.getRegistryName().func_110624_b() + ":bombcarts/" + data.getRegistryName().func_110623_a();
            cartModelMap.put(data, new ModelResourceLocation(resourcePath, "inventory"));
        }
        ModelLoader.registerItemVariants((Item)ItemReg.itemBombCart, (ResourceLocation[])((ResourceLocation[])cartModelMap.values().stream().map(model -> new ResourceLocation(model.func_110624_b() + ":" + model.func_110623_a())).toArray(ResourceLocation[]::new)));
        ModelLoader.setCustomMeshDefinition((Item)ItemReg.itemBombCart, (ItemMeshDefinition)new ItemModelMapperExplosive(cartModelMap, cartModelMap.get(ExplosiveRefs.CONDENSED)));
    }

    protected static void registerMissileRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_MISSILE_REGISTRY.getExplosives()) {
            String resourcePath = data.getRegistryName().func_110624_b() + ":missiles/" + data.getRegistryName().func_110623_a();
            missileModelMap.put(data, new ModelResourceLocation(resourcePath, "inventory"));
        }
        ModelLoader.registerItemVariants((Item)ItemReg.itemMissile, (ResourceLocation[])((ResourceLocation[])missileModelMap.values().stream().map(model -> new ResourceLocation(model.func_110624_b() + ":" + model.func_110623_a())).toArray(ResourceLocation[]::new)));
        ModelLoader.setCustomMeshDefinition((Item)ItemReg.itemMissile, (ItemMeshDefinition)new ItemModelMapperExplosive(missileModelMap, missileModelMap.get(ExplosiveRefs.CONDENSED)));
    }

    protected static void registerCraftingRender(ItemCrafting itemCrafting) {
        if (itemCrafting != null) {
            String resourcePath = itemCrafting.getRegistryName().toString();
            for (int i = 0; i < itemCrafting.subItems.length; ++i) {
                String subItem = itemCrafting.subItems[i];
                ModelLoader.setCustomModelResourceLocation((Item)itemCrafting, (int)i, (ModelResourceLocation)new ModelResourceLocation(resourcePath, "name=" + subItem));
            }
        }
    }

    protected static void newBlockModel(Block block, int meta, String varient, String sub) {
        if (block != null) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName() + sub, varient));
        }
    }

    protected static void newItemModel(Item item, int meta, String varient, String sub) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + sub, varient));
        }
    }

    public static String getPropertyString(Map<IProperty<?>, Comparable<?>> values, String ... extrasArgs) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(ClientReg.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("inventory");
        }
        for (String args : extrasArgs) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            stringbuilder.append(args);
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> comparable) {
        return property.func_177702_a(comparable);
    }
}

