/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic;

import icbm.classic.CommonProxy;
import icbm.classic.api.EnumTier;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.NBTConstants;
import icbm.classic.api.reg.events.ExplosiveContentRegistryEvent;
import icbm.classic.api.reg.events.ExplosiveRegistryEvent;
import icbm.classic.client.ICBMCreativeTab;
import icbm.classic.command.CommandICBM;
import icbm.classic.config.ConfigItems;
import icbm.classic.config.ConfigThread;
import icbm.classic.content.entity.missile.CapabilityMissile;
import icbm.classic.content.items.behavior.BombCartDispenseBehavior;
import icbm.classic.content.items.behavior.GrenadeDispenseBehavior;
import icbm.classic.content.potion.ContagiousPoison;
import icbm.classic.content.potion.PoisonContagion;
import icbm.classic.content.potion.PoisonFrostBite;
import icbm.classic.content.potion.PoisonToxin;
import icbm.classic.content.reg.ExplosiveInit;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.datafix.EntityExplosiveDataFixer;
import icbm.classic.datafix.EntityGrenadeDataFixer;
import icbm.classic.datafix.TileExplosivesDataFixer;
import icbm.classic.datafix.TileRadarStationDataFixer;
import icbm.classic.lib.capability.emp.CapabilityEMP;
import icbm.classic.lib.capability.ex.CapabilityExplosive;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.energy.system.EnergySystemFE;
import icbm.classic.lib.explosive.reg.ExBlockContentReg;
import icbm.classic.lib.explosive.reg.ExGrenadeContentReg;
import icbm.classic.lib.explosive.reg.ExMinecartContentReg;
import icbm.classic.lib.explosive.reg.ExMissileContentReg;
import icbm.classic.lib.explosive.reg.ExplosiveRegistry;
import icbm.classic.lib.network.netty.PacketManager;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.thread.WorkerThreadManager;
import icbm.classic.prefab.item.LootEntryItemStack;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="icbmclassic", name="ICBM-Classic", version="1.12.2-4.0.0.20191109044626", dependencies="", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public final class ICBMClassic {
    public static final boolean runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
    @Mod.Instance(value="icbmclassic")
    public static ICBMClassic INSTANCE;
    @Mod.Metadata(value="icbmclassic")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="icbm.classic.client.ClientProxy", serverSide="icbm.classic.CommonProxy")
    public static CommonProxy proxy;
    public static final String DOMAIN = "icbmclassic";
    public static final String PREFIX = "icbmclassic:";
    public static final String MAJOR_VERSION = "4";
    public static final String MINOR_VERSION = "0";
    public static final String REVISION_VERSION = "0";
    public static final String BUILD_VERSION = "20191109044626";
    public static final String MC_VERSION = "1.12.2";
    public static final String VERSION = "1.12.2-4.0.0.20191109044626";
    public static final String DEPENDENCIES = "";
    public static final String TEXTURE_DIRECTORY = "textures/";
    public static final String GUI_DIRECTORY = "textures/gui/";
    public static final int MAP_HEIGHT = 255;
    protected static Logger logger;
    public static final PacketManager packetHandler;
    public static Block blockRadioactive;
    public static final ContagiousPoison poisonous_potion;
    public static final ContagiousPoison contagios_potion;
    public static final ICBMCreativeTab CREATIVE_TAB;
    public static ModFixs modFixs;

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (ConfigItems.ENABLE_INGOTS_ITEMS) {
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ItemReg.itemIngotClump, 1, 0), (ItemStack)new ItemStack((Item)ItemReg.itemIngot, 1, 0), (float)0.1f);
        }
        if (ConfigItems.ENABLE_PLATES_ITEMS) {
            GameRegistry.addSmelting((ItemStack)ItemReg.itemPlate.getStack("iron", 1), (ItemStack)new ItemStack(Items.field_151042_j), (float)0.0f);
        }
    }

    @SubscribeEvent
    public static void registerLoot(LootTableLoadEvent event) {
        LootPool lootPool;
        String VANILLA_LOOT_POOL_ID = "main";
        if (event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186422_d)) {
            LootPool lootPool2;
            if (ConfigItems.ENABLE_LOOT_DROPS && (lootPool2 = event.getTable().getPool("main")) != null) {
                if (ConfigItems.ENABLE_INGOTS_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:ingot.copper", ItemReg.itemIngot.getStack("copper", 10), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:ingot.steel", ItemReg.itemIngot.getStack("steel", 10), 20, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_PLATES_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:plate.steel", ItemReg.itemPlate.getStack("steel", 5), 30, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_WIRES_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:wire.copper", ItemReg.itemWire.getStack("copper", 20), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:wire.gold", ItemReg.itemWire.getStack("gold", 15), 30, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_CIRCUIT_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.basic", ItemReg.itemCircuit.getStack("basic", 15), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.advanced", ItemReg.itemCircuit.getStack("advanced", 11), 30, 3, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.elite", ItemReg.itemCircuit.getStack("elite", 8), 30, 3, new LootCondition[0]));
                }
            }
        } else if (event.getName().equals((Object)LootTableList.field_186434_p) && ConfigItems.ENABLE_SULFUR_LOOT_DROPS && (lootPool = event.getTable().getPool("main")) != null) {
            lootPool.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:sulfur", new ItemStack(ItemReg.itemSulfurDust, 10, 0), 2, 0, new LootCondition[0]));
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NBTConstants.ensureThatAllTagNamesAreDistinct();
        proxy.preInit();
        EnergySystem.register(new EnergySystemFE());
        CapabilityEMP.register();
        CapabilityMissile.register();
        CapabilityExplosive.register();
        modFixs = FMLCommonHandler.instance().getDataFixer().init(DOMAIN, 1);
        modFixs.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new EntityExplosiveDataFixer());
        modFixs.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new EntityGrenadeDataFixer());
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileExplosivesDataFixer());
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileRadarStationDataFixer());
        MinecraftForge.EVENT_BUS.register((Object)RadarRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RadioRegistry.INSTANCE);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.handleExRegistry(event.getModConfigurationDirectory());
    }

    private void handleExRegistry(File configMainFolder) {
        ExplosiveRegistry explosiveRegistry = new ExplosiveRegistry();
        ICBMClassicAPI.EXPLOSIVE_REGISTRY = explosiveRegistry;
        ICBMClassicAPI.EX_BLOCK_REGISTRY = new ExBlockContentReg();
        ICBMClassicAPI.EX_GRENADE_REGISTRY = new ExGrenadeContentReg();
        ICBMClassicAPI.EX_MINECART_REGISTRY = new ExMinecartContentReg();
        ICBMClassicAPI.EX_MISSILE_REGISTRY = new ExMissileContentReg();
        explosiveRegistry.loadReg(new File(configMainFolder, "icbmclassic/explosive_reg.json"));
        explosiveRegistry.registerContentRegistry(ICBMClassicAPI.EX_BLOCK_REGISTRY);
        explosiveRegistry.registerContentRegistry(ICBMClassicAPI.EX_GRENADE_REGISTRY);
        explosiveRegistry.registerContentRegistry(ICBMClassicAPI.EX_MISSILE_REGISTRY);
        explosiveRegistry.registerContentRegistry(ICBMClassicAPI.EX_MINECART_REGISTRY);
        MinecraftForge.EVENT_BUS.post((Event)new ExplosiveContentRegistryEvent(explosiveRegistry));
        explosiveRegistry.lockNewContentTypes();
        ExplosiveInit.init();
        MinecraftForge.EVENT_BUS.post((Event)new ExplosiveRegistryEvent(explosiveRegistry));
        explosiveRegistry.lockNewExplosives();
        explosiveRegistry.getExplosives().forEach(ex -> ICBMClassicAPI.EX_BLOCK_REGISTRY.enableContent(ex.getRegistryName()));
        explosiveRegistry.getExplosives().forEach(ex -> ICBMClassicAPI.EX_MISSILE_REGISTRY.enableContent(ex.getRegistryName()));
        explosiveRegistry.getExplosives().forEach(ex -> ICBMClassicAPI.EX_MINECART_REGISTRY.enableContent(ex.getRegistryName()));
        explosiveRegistry.getExplosives().stream().filter(ex -> ex.getTier() == EnumTier.ONE).forEach(ex -> ICBMClassicAPI.EX_GRENADE_REGISTRY.enableContent(ex.getRegistryName()));
        explosiveRegistry.completeLock();
        explosiveRegistry.saveReg();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        packetHandler.init();
        CREATIVE_TAB.init();
        this.setModMetadata(DOMAIN, "ICBM-Classic", metadata);
        ItemReg.itemIngot.registerOreNames(new String[0]);
        ItemReg.itemPlate.registerOreNames("iron");
        ItemReg.itemCircuit.registerOreNames(new String[0]);
        ItemReg.itemWire.registerOreNames(new String[0]);
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)new ItemStack(ItemReg.itemSulfurDust));
        OreDictionary.registerOre((String)"dustSaltpeter", (ItemStack)new ItemStack(ItemReg.itemSaltpeterDust));
        ICBMClassic.CREATIVE_TAB.itemStack = new ItemStack(ItemReg.itemMissile);
        PoisonToxin.INSTANCE = MobEffects.field_76436_u;
        PoisonContagion.INSTANCE = MobEffects.field_76436_u;
        PoisonFrostBite.INSTANCE = MobEffects.field_76436_u;
        if (ItemReg.itemGrenade != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)ItemReg.itemGrenade, (Object)new GrenadeDispenseBehavior());
        }
        if (ItemReg.itemBombCart != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)ItemReg.itemBombCart, (Object)new BombCartDispenseBehavior());
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    public void setModMetadata(String id, String name, ModMetadata metadata) {
        metadata.modId = id;
        metadata.name = name;
        metadata.description = "ICBM is a Minecraft Mod that introduces intercontinental ballistic missiles to Minecraft. But the fun doesn't end there! This mod also features many different explosives, missiles and machines classified in three different tiers. If strategic warfare, carefully coordinated airstrikes, messing with matter and general destruction are up your alley, then this mod is for you!";
        metadata.url = "http://www.builtbroken.com/";
        metadata.logoFile = "/icbm_logo.png";
        metadata.version = VERSION;
        metadata.authorList = Arrays.asList("Calclavia", "DarkGuardsman aka Darkcow");
        metadata.credits = "Please visit the website.";
        metadata.autogenerated = false;
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        serverCommandManager.func_71560_a((ICommand)new CommandICBM("icbmc"));
        if (!Loader.isModLoaded((String)"icbm")) {
            serverCommandManager.func_71560_a((ICommand)new CommandICBM("icbm"));
        }
        WorkerThreadManager.INSTANCE = new WorkerThreadManager(ConfigThread.THREAD_COUNT);
        WorkerThreadManager.INSTANCE.startThreads();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        WorkerThreadManager.INSTANCE.killThreads();
    }

    public static Logger logger() {
        return logger;
    }

    public static boolean isJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.") && !element.getClassName().startsWith("com.builtbroken.mc.testing.junit.VoltzTestRunner")) continue;
            return true;
        }
        return false;
    }

    static {
        logger = LogManager.getLogger((String)DOMAIN);
        packetHandler = new PacketManager(DOMAIN);
        blockRadioactive = Blocks.field_150391_bh;
        poisonous_potion = new ContagiousPoison("Chemical", 0, false);
        contagios_potion = new ContagiousPoison("Contagious", 1, true);
        CREATIVE_TAB = new ICBMCreativeTab(DOMAIN);
    }
}

