/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.spawn.impl;

import net.minecraft.world.World;

public class DimensionFilter {
    private final String name;
    private final boolean isRange;
    private final int minId;
    private final int maxId;
    private final Type type;

    public DimensionFilter(String name, boolean isRange, int minId, int maxId, Type type) {
        this.name = name;
        this.isRange = isRange;
        this.minId = minId;
        this.maxId = maxId;
        this.type = type;
    }

    public DimensionFilter(String name, Type type) {
        this(name, false, Integer.MAX_VALUE, Integer.MAX_VALUE, type);
    }

    public DimensionFilter(int id, Type type) {
        this(null, false, id, Integer.MAX_VALUE, type);
    }

    public DimensionFilter(int minId, int maxId, Type type) {
        this(null, true, minId, maxId, type);
    }

    public Type canSpawnInDimension(World world) {
        if (this.name != null) {
            return this.name.equals(world.field_73011_w.func_186058_p().func_186065_b()) ? this.type : Type.NONE;
        }
        int id = world.field_73011_w.getDimension();
        if (this.isRange) {
            return id < this.minId || id > this.maxId ? Type.NONE : this.type;
        }
        return id != this.minId ? Type.NONE : this.type;
    }

    public static enum Type {
        NONE,
        BLACK,
        WHITE;


        public Type combine(Type other) {
            if (this == other) {
                return this;
            }
            if (this == NONE) {
                return other;
            }
            if (other == NONE) {
                return this;
            }
            return WHITE;
        }
    }
}

