/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.spawn;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.recipe.RecipeConfig;
import crazypants.enderio.zoo.spawn.ISpawnEntry;
import crazypants.enderio.zoo.spawn.SpawnConfigParser;
import crazypants.enderio.zoo.spawn.impl.SpawnEntry;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class SpawnConfig {
    @Nonnull
    public static final String CONFIG_NAME_CORE = "SpawnConfig_Core.xml";
    @Nonnull
    public static final String CONFIG_NAME_USER = "SpawnConfig_User.xml";

    public static List<SpawnEntry> loadSpawnConfig() {
        List<SpawnEntry> result;
        File coreFile = new File(EnderIO.getConfigHandler().getConfigDirectory(), CONFIG_NAME_CORE);
        String defaultVals = null;
        try {
            defaultVals = RecipeConfig.readRecipes((File)coreFile, (String)CONFIG_NAME_CORE, (boolean)true);
        }
        catch (IOException e) {
            Log.error((Object[])new Object[]{"Could not load core spawn config file SpawnConfig_Core.xml from jar: " + e.getMessage()});
            e.printStackTrace();
            return null;
        }
        try {
            result = SpawnConfigParser.parseSpawnConfig(defaultVals);
        }
        catch (Exception e) {
            Log.error((Object[])new Object[]{"Error parsing SpawnConfig_Core.xml:" + e});
            return Collections.emptyList();
        }
        Log.info((Object[])new Object[]{"Loaded " + result.size() + " entries from core spawn config."});
        File userFile = new File(EnderIO.getConfigHandler().getConfigDirectory(), CONFIG_NAME_USER);
        try {
            String userText = RecipeConfig.readRecipes((File)userFile, (String)CONFIG_NAME_USER, (boolean)false);
            if (userText.trim().length() == 0) {
                Log.error((Object[])new Object[]{"Empty user config file: " + userFile.getAbsolutePath()});
            } else {
                List<SpawnEntry> userEntries = SpawnConfigParser.parseSpawnConfig(userText);
                Log.info((Object[])new Object[]{"Loaded " + userEntries.size() + " entries from user spawn config."});
                SpawnConfig.merge(userEntries, result);
            }
        }
        catch (Exception e) {
            Log.error((Object[])new Object[]{"Could not load user defined spawn entries from file: SpawnConfig_User.xml"});
            e.printStackTrace();
        }
        return result;
    }

    private static void merge(List<SpawnEntry> userEntries, List<SpawnEntry> result) {
        for (SpawnEntry entry : userEntries) {
            SpawnConfig.removeFrom(entry, result);
            result.add(entry);
        }
    }

    private static void removeFrom(ISpawnEntry useEntry, List<SpawnEntry> result) {
        ISpawnEntry toRemove = null;
        for (ISpawnEntry iSpawnEntry : result) {
            if (!useEntry.getId().equals(iSpawnEntry.getId())) continue;
            toRemove = iSpawnEntry;
            break;
        }
        if (toRemove != null) {
            Log.info((Object[])new Object[]{"Replace spawn config for " + toRemove.getId() + " with user supplied entry."});
            result.remove(toRemove);
        }
    }
}

